/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.j2meplugin.module.settings.general.UserKeysConfigurable;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.ui.OTASettingsConfigurable;
import com.intellij.j2meplugin.run.ui.editors.EmulatorEditor;
import com.intellij.j2meplugin.util.J2MEClassBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class J2MERunConfigurationEditor
extends SettingsEditor<J2MERunConfiguration>
implements CheckableRunConfigurationEditor<J2MERunConfiguration> {
    private EditorPanel myEditor;
    private final Project myProject;
    private final J2MERunConfiguration myJ2MERunConfiguration;
    private static final Logger LOG = Logger.getInstance(J2MERunConfigurationEditor.class);

    public J2MERunConfigurationEditor(Project project, J2MERunConfiguration j2MERunConfiguration) {
        this.myProject = project;
        this.myJ2MERunConfiguration = j2MERunConfiguration;
    }

    public void resetEditorFrom(@NotNull J2MERunConfiguration j2merc) {
        if (j2merc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "j2merc", "com/intellij/j2meplugin/run/ui/J2MERunConfigurationEditor", "resetEditorFrom"));
        }
        ((ModulesComboBox)this.myEditor.myModule.getComponent()).setSelectedModule(j2merc.getModule());
        if (this.myEditor.getEmulatorRunOptions() != null) {
            this.myEditor.getEmulatorRunOptions().reset();
        }
        this.myEditor.myJad.setText(j2merc.JAD_NAME);
        this.myEditor.myClass.setText(j2merc.MAIN_CLASS_NAME);
        this.myEditor.myUseClasses.setSelected(j2merc.IS_CLASSES);
        this.myEditor.myUseJad.setSelected(!j2merc.IS_CLASSES);
        this.myEditor.myUserKeysConfigurable.setUserDefinedOptions(j2merc.userParameters);
        if (this.myEditor.myOTASettings != null) {
            this.myEditor.myOTASettings.resetEditorFrom(j2merc);
        }
        this.myEditor.myUseOTA.setSelected(j2merc.IS_OTA);
        ((RawCommandLineEditor)this.myEditor.myProgramParameters.getComponent()).setText(j2merc.COMMAND_LINE_PARAMETERS);
        this.myEditor.changeConfigurationTargetSelection();
    }

    public void applyEditorTo(@NotNull J2MERunConfiguration j2merc) throws ConfigurationException {
        if (j2merc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "j2merc", "com/intellij/j2meplugin/run/ui/J2MERunConfigurationEditor", "applyEditorTo"));
        }
        j2merc.setModule(this.myEditor.getModule());
        if (this.myEditor.getEmulatorRunOptions() != null) {
            this.myEditor.getEmulatorRunOptions().apply();
        }
        j2merc.JAD_NAME = this.myEditor.myJad.getText();
        j2merc.MAIN_CLASS_NAME = this.myEditor.myClass.getText();
        j2merc.IS_CLASSES = this.myEditor.myUseClasses.isSelected();
        if (this.myEditor.myUserKeysConfigurable != null) {
            this.myEditor.myUserKeysConfigurable.getTable().stopEditing();
            j2merc.userParameters = new ArrayList(this.myEditor.myUserKeysConfigurable.getUserDefinedOptions().getItems());
        }
        if (this.myEditor.myOTASettings != null) {
            this.myEditor.myOTASettings.applyEditorTo(j2merc);
        }
        j2merc.IS_OTA = this.myEditor.myUseOTA.isSelected();
        j2merc.COMMAND_LINE_PARAMETERS = ((RawCommandLineEditor)this.myEditor.myProgramParameters.getComponent()).getText();
    }

    @NotNull
    public JComponent createEditor() {
        this.myEditor = new EditorPanel();
        JComponent jComponent = this.myEditor.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/run/ui/J2MERunConfigurationEditor", "createEditor"));
        }
        return jComponent;
    }

    public void checkEditorData(J2MERunConfiguration j2merc) {
        try {
            j2merc.setModule(this.myEditor.getModule());
            if (this.myEditor.getEmulatorRunOptions() != null) {
                this.myEditor.getEmulatorRunOptions().apply();
            }
            j2merc.JAD_NAME = this.myEditor.myJad.getText();
            j2merc.MAIN_CLASS_NAME = this.myEditor.myClass.getText();
            j2merc.IS_CLASSES = this.myEditor.myUseClasses.isSelected();
            if (this.myEditor.myOTASettings != null) {
                this.myEditor.myOTASettings.applyEditorTo(j2merc);
            }
            j2merc.IS_OTA = this.myEditor.myUseOTA.isSelected();
            j2merc.COMMAND_LINE_PARAMETERS = ((RawCommandLineEditor)this.myEditor.myProgramParameters.getComponent()).getText();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    private class EditorPanel
    implements PanelWithAnchor {
        private JPanel myWholePanel;
        private JComponent anchor;
        private LabeledComponent<ModulesComboBox> myModule;
        private JPanel myChoosenEmulatorSettingsPlace;
        private LabeledComponent<RawCommandLineEditor> myProgramParameters;
        private JPanel myConfigurationPanel;
        private JRadioButton myUseClasses;
        private JRadioButton myUseJad;
        private JRadioButton myUseOTA;
        private TextFieldWithBrowseButton myClass;
        private JLabel myClassLabel;
        private JPanel myClassPanel;
        private TextFieldWithBrowseButton myJad;
        private JLabel myJadLabel;
        private JPanel myJadPanel;
        private JPanel myOTAPanel;
        private JPanel myUserOptionsPanel;
        private UserKeysConfigurable myUserKeysConfigurable;
        private OTASettingsConfigurable myOTASettings;
        private EmulatorEditor myEmulatorEditor;

        public EmulatorEditor getEmulatorRunOptions() {
            if (this.myEmulatorEditor == null) {
                this.fillEmulatorEditor(this.getModule());
            }
            return this.myEmulatorEditor;
        }

        public EditorPanel() {
            this.$$$setupUI$$$();
            this.myConfigurationPanel.setVisible(false);
            this.myProgramParameters.setComponent((JComponent)new RawCommandLineEditor());
            ((RawCommandLineEditor)this.myProgramParameters.getComponent()).setDialogCaption(this.myProgramParameters.getRawText());
            this.myModule.setComponent((JComponent)new ModulesComboBox());
            ((ModulesComboBox)this.myModule.getComponent()).fillModules(J2MERunConfigurationEditor.this.myProject, (ModuleType)J2MEModuleType.getInstance());
            ((ModulesComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorPanel.this.moduleChanged();
                }
            });
            this.myChoosenEmulatorSettingsPlace.setLayout(new BorderLayout());
            this.myOTAPanel.setVisible(false);
            this.myUserOptionsPanel.setLayout(new BorderLayout());
            this.myUserOptionsPanel.setVisible(false);
            this.myUseOTA.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorPanel.this.changeConfigurationTargetSelection();
                }
            });
            this.myUseJad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorPanel.this.changeConfigurationTargetSelection();
                }
            });
            this.myUseClasses.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditorPanel.this.changeConfigurationTargetSelection();
                }
            });
            this.myClass.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (EditorPanel.this.getModule() == null) {
                        return;
                    }
                    J2MEClassBrowser j2MEClassBrowser = new J2MEClassBrowser(EditorPanel.this.getModule());
                    j2MEClassBrowser.show();
                    j2MEClassBrowser.setField(EditorPanel.this.myClass);
                }
            });
            this.myJad.addBrowseFolderListener(J2MEBundle.message("run.configuration.browse.file", new Object[0]), J2MEBundle.message("run.configuration.file.to.start", new Object[0]), J2MERunConfigurationEditor.this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            this.myUseJad.setSelected(true);
            this.myClassPanel.setVisible(false);
            this.setAnchor((JComponent)this.myModule.getLabel());
        }

        private void createKeysConfigurable() {
            this.myUserKeysConfigurable = new UserKeysConfigurable(new HashSet<UserDefinedOption>());
            this.myUserOptionsPanel.removeAll();
            this.myUserOptionsPanel.add((Component)this.myUserKeysConfigurable.getUserKeysPanel(), "Center");
        }

        public JComponent getComponent() {
            this.fillEmulatorEditor(J2MERunConfigurationEditor.this.myJ2MERunConfiguration.getModule());
            this.createKeysConfigurable();
            JPanel myBorder = new JPanel(new BorderLayout());
            myBorder.add((Component)this.myWholePanel, "Center");
            return myBorder;
        }

        private Module getModule() {
            return ((ModulesComboBox)this.myModule.getComponent()).getSelectedModule();
        }

        public void moduleChanged() {
            this.myConfigurationPanel.setVisible(false);
            this.fillEmulatorEditor(this.getModule());
            if (this.getModule() == null) {
                return;
            }
            Sdk projectJdk = ModuleRootManager.getInstance((Module)this.getModule()).getSdk();
            if (projectJdk == null || !MobileSdk.checkCorrectness(projectJdk, this.getModule())) {
                return;
            }
            this.myConfigurationPanel.setVisible(true);
            String[] otaCommands = ((Emulator)projectJdk.getSdkAdditionalData()).getOTACommands(projectJdk.getHomePath());
            LOG.assertTrue(otaCommands != null);
            if (otaCommands.length > 0) {
                this.myOTASettings = new OTASettingsConfigurable(projectJdk, this.getModule());
                this.myOTASettings.setCommands(otaCommands);
                Disposer.register((Disposable)J2MERunConfigurationEditor.this, (Disposable)this.myOTASettings);
                this.myUseOTA.setVisible(true);
            } else {
                this.myUseOTA.setVisible(false);
            }
            EmulatorType emulatorType = MobileSdk.getEmulatorType(projectJdk, this.getModule());
            LOG.assertTrue(emulatorType != null);
            MobileApplicationType mobileApplicationType = MobileModuleUtil.getMobileApplicationTypeByName(emulatorType.getApplicationType());
            LOG.assertTrue(mobileApplicationType != null);
            String extension = mobileApplicationType.getExtension();
            this.myUseJad.setText(StringUtil.capitalize((String)extension));
            this.myJadLabel.setText(J2MEBundle.message("file.label", StringUtil.capitalize((String)extension)));
            this.myClassLabel.setText(StringUtil.capitalize((String)J2MEBundle.message("klass.label", mobileApplicationType.getPresentableClassName())));
            MobileModuleSettings moduleSettings = MobileModuleSettings.getInstance(this.getModule());
            LOG.assertTrue(moduleSettings != null);
            this.myJad.setText(moduleSettings.getMobileDescriptionPath());
            this.myUseJad.setSelected(true);
            this.changeConfigurationTargetSelection();
        }

        private void changeConfigurationTargetSelection() {
            if (this.getModule() == null) {
                return;
            }
            this.myClassPanel.setVisible(this.myUseClasses.isSelected());
            this.myJadPanel.setVisible(this.myUseJad.isSelected());
            this.myUserOptionsPanel.setVisible(false);
            this.myOTAPanel.setVisible(false);
            if (this.myUseClasses.isSelected()) {
                if (J2MEModuleProperties.getInstance(this.getModule()).getMobileApplicationType().isUserParametersEnable()) {
                    this.myUserOptionsPanel.setVisible(true);
                } else {
                    this.myUserOptionsPanel.setVisible(false);
                }
            }
            if (this.myUseJad.isSelected()) {
                this.myJadPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myUseJad.getText().toUpperCase(), (boolean)true));
            }
            if (this.myUseOTA.isSelected()) {
                this.myOTAPanel.removeAll();
                this.myOTAPanel.add((Component)this.myOTASettings.createEditor(), "Center");
                this.myOTAPanel.setVisible(true);
            }
        }

        private void fillEmulatorEditor(Module module) {
            if (module != null) {
                Sdk projectJdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (projectJdk != null && MobileSdk.checkCorrectness(projectJdk, this.getModule())) {
                    this.myChoosenEmulatorSettingsPlace.removeAll();
                    Emulator emulator = (Emulator)projectJdk.getSdkAdditionalData();
                    EmulatorType emulatorType = emulator.getEmulatorType();
                    LOG.assertTrue(emulatorType != null);
                    this.myEmulatorEditor = new EmulatorEditor(J2MERunConfigurationEditor.this.myJ2MERunConfiguration, emulatorType.getAvailableSkins(projectJdk.getHomePath()), projectJdk);
                    JComponent emulatorEditor = this.myEmulatorEditor.createComponent();
                    if (this.myEmulatorEditor.isVisible()) {
                        this.myChoosenEmulatorSettingsPlace.add((Component)emulatorEditor, "Center");
                        this.myChoosenEmulatorSettingsPlace.setVisible(true);
                    } else {
                        this.myChoosenEmulatorSettingsPlace.setVisible(false);
                    }
                    this.myChoosenEmulatorSettingsPlace.updateUI();
                }
            } else {
                this.myChoosenEmulatorSettingsPlace.setVisible(false);
            }
        }

        public JComponent getAnchor() {
            return this.anchor;
        }

        public void setAnchor(JComponent anchor) {
            this.anchor = anchor;
            this.myProgramParameters.setAnchor(anchor);
            this.myModule.setAnchor(anchor);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JLabel jLabel;
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            JPanel jPanel2;
            JLabel jLabel2;
            TextFieldWithBrowseButton textFieldWithBrowseButton2;
            JPanel jPanel3;
            JPanel jPanel4;
            JRadioButton jRadioButton3;
            JPanel jPanel5;
            JPanel jPanel6;
            LabeledComponent labeledComponent;
            LabeledComponent labeledComponent2;
            JPanel jPanel7;
            this.myWholePanel = jPanel7 = new JPanel();
            jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myModule = labeledComponent2 = new LabeledComponent();
            labeledComponent2.setLabelLocation("West");
            labeledComponent2.setLabelInsets(new Insets(0, 0, 0, 0));
            labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
            labeledComponent2.setComponentClass("javax.swing.JComboBox");
            jPanel7.add((Component)labeledComponent2, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 0, null, null, null));
            this.myProgramParameters = labeledComponent = new LabeledComponent();
            labeledComponent.setLabelLocation("West");
            labeledComponent.setText(ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.emulator.parameters"));
            jPanel7.add((Component)labeledComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
            this.myChoosenEmulatorSettingsPlace = jPanel6 = new JPanel();
            jPanel7.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myConfigurationPanel = jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel7.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myUseOTA = jRadioButton3 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota"));
            jPanel5.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel8 = new JPanel();
            jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel5.add((Component)jPanel8, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
            this.myOTAPanel = jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout(0, 0));
            jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel8.add((Component)jPanel4, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota.settings"), (int)0, (int)0, null, null));
            this.myClassPanel = jPanel3 = new JPanel();
            jPanel3.setLayout(new GridBagLayout());
            jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
            jPanel8.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.class.settings.title"), (int)0, (int)0, null, null));
            this.myClass = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel3.add((Component)textFieldWithBrowseButton2, gridBagConstraints);
            this.myClassLabel = jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("klass.common.label"));
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
            jPanel3.add((Component)jLabel2, gridBagConstraints2);
            this.myUserOptionsPanel = jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout(0, 0));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.insets = new Insets(10, 5, 0, 0);
            jPanel3.add((Component)jPanel2, gridBagConstraints3);
            this.myJadPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
            jPanel8.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myJad = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(250, -1), null));
            this.myJadLabel = jLabel = new JLabel();
            jLabel.setText("");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myUseClasses = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("klass.common"));
            jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myUseJad = jRadioButton = new JRadioButton();
            jRadioButton.setText("");
            jPanel5.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel5.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton3);
            buttonGroup.add(jRadioButton2);
            buttonGroup.add(jRadioButton);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

