/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.web.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.web.mvc.model.SpringMVCModel;
import com.intellij.spring.web.mvc.model.SpringMVCModelService;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringMvcUsagesCollector
extends AbstractApplicationUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/web/mvc/SpringMvcUsagesCollector", "getProjectUsages"));
        }
        HashSet usages = new HashSet();
        ApplicationManager.getApplication().runReadAction(() -> SpringMvcUsagesCollector.lambda$getProjectUsages$0(project, (Set)usages));
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMvcUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Spring MVC");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/SpringMvcUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    private static /* synthetic */ void lambda$getProjectUsages$0(@NotNull Project project, Set usages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/web/mvc/SpringMvcUsagesCollector", "lambda$getProjectUsages$0"));
        }
        if (!SpringMvcLibraryUtil.isSpringMVCEnabled((Project)project)) {
            return;
        }
        int mvcModelsCount = 0;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            SpringMVCModel mvcModel;
            Collection webFacets;
            SpringFacet springFacet;
            if (!SpringMvcLibraryUtil.hasSpringMvcLibrary((Module)module) || (springFacet = SpringFacet.getInstance((Module)module)) == null || (webFacets = WebFacet.getInstances((Module)module)).isEmpty() || (mvcModel = SpringMVCModelService.getInstance().getModel((WebFacet)webFacets.iterator().next(), springFacet)) == null) continue;
            ++mvcModelsCount;
            List resolvers = mvcModel.getViewResolvers();
            usages.add(new UsageDescriptor("viewResolvers_" + resolvers.size(), 1));
            for (ViewResolver resolver : resolvers) {
                usages.add(new UsageDescriptor("viewResolver_" + resolver.getID(), 1));
            }
            for (SpringModel springModel : mvcModel.getAllModels()) {
                SpringFileSet fileSet = springModel.getFileSet();
                assert (fileSet != null) : springModel;
                String id = fileSet.getId();
                if (id.startsWith("initializer")) {
                    usages.add(new UsageDescriptor("fileset_initializer", 1));
                    continue;
                }
                if (!id.startsWith("web")) continue;
                usages.add(new UsageDescriptor("fileset_webXml", 1));
            }
        }
        usages.add(new UsageDescriptor("mvcModelsInProject_" + mvcModelsCount, 1));
    }
}

