/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.web.mvc.pathVariables;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.web.mvc.pathVariables.MVCPathVariableReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MVCPathVariableReferenceProvider
extends PsiReferenceProvider {
    private static final MVCPathVariableReferenceProvider INSTANCE = new MVCPathVariableReferenceProvider();

    public static void register(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(MVCPathVariableReference.PATTERN, (PsiReferenceProvider)INSTANCE, 100.0);
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReferenceProvider", "getReferencesByElement"));
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)element;
        Object o = expression.getValue();
        if (!(o instanceof String)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String escaped = StringUtil.escapeStringCharacters((String)((String)o));
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)escaped, (String)"{", (String)"}", (boolean)false, (boolean)true);
        PsiReference[] psiReferenceArray = (PsiReference[])ContainerUtil.map2Array((Collection)ranges, PsiReference.class, textRange -> {
            String rangeSubString = textRange.substring(escaped);
            int i = rangeSubString.indexOf(58);
            TextRange nameRange = i == -1 ? textRange : textRange.grown(-(textRange.getLength() - i));
            return new MVCPathVariableReference(expression, nameRange);
        });
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/web/mvc/pathVariables/MVCPathVariableReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    static PsiReference[] createMVCPathVariableReferencesForReferenceExpression(PsiReferenceExpression element) {
        PsiExpression initializer;
        PsiElement resolve = element.resolve();
        if (resolve instanceof PsiVariable && (initializer = ((PsiVariable)resolve).getInitializer()) instanceof PsiLiteralExpression) {
            return INSTANCE.getReferencesByElement((PsiElement)initializer, new ProcessingContext());
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

