/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.schema.FlexMxmlNSDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.MxmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.RootTagFilter;
import com.intellij.psi.meta.MetaDataContributor;
import com.intellij.psi.meta.MetaDataRegistrar;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FlexApplicationComponent
extends FileTypeFactory
implements MetaDataContributor,
StandardResourceProvider {
    private static final Icon ICON = AllIcons.FileTypes.JavaClass;
    public static final FileType SWF_FILE_TYPE = new FileType(){

        @NotNull
        public String getName() {
            if ("SWF" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexApplicationComponent$1", "getName"));
            }
            return "SWF";
        }

        @NotNull
        public String getDescription() {
            if ("SWF file type" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexApplicationComponent$1", "getDescription"));
            }
            return "SWF file type";
        }

        @NotNull
        public String getDefaultExtension() {
            if ("swf" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexApplicationComponent$1", "getDefaultExtension"));
            }
            return "swf";
        }

        public Icon getIcon() {
            return ICON;
        }

        public boolean isBinary() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/FlexApplicationComponent$1", "getCharset"));
            }
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/javascript/flex/FlexApplicationComponent$1", "getCharset"));
            }
            return null;
        }
    };
    public static final Language DECOMPILED_SWF = new Language((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, "Decompiled SWF", new String[0]){};
    public static final LanguageFileType MXML = new MxmlFileType();
    @NonNls
    public static final String HTTP_WWW_ADOBE_COM_2006_FLEX_CONFIG = "http://www.adobe.com/2006/flex-config";
    public static final String[] AIR_VERSIONS = new String[]{"1.0", "1.1", "1.5", "1.5.1", "1.5.2", "1.5.3", "2.0", "2.5", "2.6", "2.7", "3.0", "3.1", "3.2", "3.3", "3.4", "3.5", "3.6", "3.7", "3.8", "3.9", "4.0", "13.0", "14.0", "15.0", "16.0", "17.0", "18.0", "19.0", "20.0", "21.0", "22.0", "23.0", "24.0", "25.0", "26.0", "27.0", "28.0", "29.0", "30.0"};

    public void contributeMetaData(@NotNull MetaDataRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/flex/FlexApplicationComponent", "contributeMetaData"));
        }
        registrar.registerMetaData((ElementFilter)new RootTagFilter((ElementFilter)new NamespaceFilter(MxmlJSClass.MXML_URIS)), FlexMxmlNSDescriptor.class);
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/flex/FlexApplicationComponent", "createFileTypes"));
        }
        consumer.consume(SWF_FILE_TYPE, "swf");
        consumer.consume((FileType)MXML, "mxml;fxg");
    }

    public void registerResources(ResourceRegistrar registrar) {
        registrar.addStdResource(HTTP_WWW_ADOBE_COM_2006_FLEX_CONFIG, "/schemas/FlexCompilerSchema.xsd", FlexApplicationComponent.class);
        registrar.addStdResource("urn:Flex:Meta", "/schemas/KnownMetaData.dtd", FlexApplicationComponent.class);
        for (String version : AIR_VERSIONS) {
            FlexApplicationComponent.registerAirDescriptorSchema(registrar, version);
        }
    }

    private static void registerAirDescriptorSchema(ResourceRegistrar registrar, String version) {
        registrar.addStdResource("http://ns.adobe.com/air/application/" + version, "/schemas/AIR_Descriptor." + version + ".xsd", FlexApplicationComponent.class);
    }
}

