/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.schema.AnyXmlElementWithAnyChildrenDescriptor;
import com.intellij.javascript.flex.mxml.schema.ClassBackedElementDescriptor;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.javascript.flex.mxml.schema.CodeContextHolder;
import com.intellij.javascript.flex.mxml.schema.FxDefinitionBackedDescriptor;
import com.intellij.javascript.flex.mxml.schema.MxmlBackedElementDescriptor;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexMxmlNSDescriptor
implements XmlNSDescriptor,
Validator<XmlDocument> {
    private XmlFile myFile;
    private String namespace;
    private Module module;
    public static final Key<String> NS_KEY = Key.create((String)"ns.key");
    public static final Key<Module> MODULE_KEY = Key.create((String)"module.key");
    private static boolean reportedAboutStackOverflow;
    private static final String[] ILLEGAL_LANGUAGE_ROOT_TAGS;

    @Nullable
    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        String localName;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/javascript/flex/mxml/schema/FlexMxmlNSDescriptor", "getElementDescriptor"));
        }
        if (MxmlJSClass.isInsideTagThatAllowsAnyXmlContent(tag)) {
            return new AnyXmlElementWithAnyChildrenDescriptor();
        }
        String namespace = tag.getNamespace();
        CodeContext context = CodeContext.getContext(namespace, this.module);
        XmlElementDescriptor descriptor = context.getElementDescriptor(localName = tag.getLocalName(), tag);
        if (descriptor == null) {
            XmlTag parentTag = tag.getParentTag();
            if (parentTag != null && namespace.equals(parentTag.getNamespace())) {
                XmlElementDescriptor parentDescriptor = parentTag.getDescriptor();
                if (parentDescriptor != null && (!(parentDescriptor instanceof ClassBackedElementDescriptor) || ClassBackedElementDescriptor.sameNs(namespace, ((ClassBackedElementDescriptor)parentDescriptor).context.namespace))) {
                    descriptor = parentDescriptor.getElementDescriptor(tag, parentTag);
                } else if (parentDescriptor != null && !reportedAboutStackOverflow) {
                    Logger.getInstance((String)this.getClass().getName()).error((Throwable)((Object)new AssertionError((Object)("avoided SOE:\n" + tag.getContainingFile().getText()))));
                    reportedAboutStackOverflow = true;
                }
            }
        } else if (tag.getParent() instanceof XmlDocument && !FlexMxmlNSDescriptor.isLegalRootElementDescriptor(descriptor)) {
            return null;
        }
        if (descriptor == null && "http://ns.adobe.com/mxml/2009".equals(tag.getNamespace())) {
            return FxDefinitionBackedDescriptor.getFxDefinitionBackedDescriptor(this.module, tag);
        }
        return descriptor;
    }

    private static boolean isLegalRootElementDescriptor(@NotNull XmlElementDescriptor _descriptor) {
        if (_descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_descriptor", "com/intellij/javascript/flex/mxml/schema/FlexMxmlNSDescriptor", "isLegalRootElementDescriptor"));
        }
        if (_descriptor instanceof ClassBackedElementDescriptor) {
            JSAttributeList attributeList;
            ClassBackedElementDescriptor descriptor = (ClassBackedElementDescriptor)_descriptor;
            PsiElement element = descriptor.getDeclaration();
            if (element instanceof JSClass && (attributeList = ((JSClass)element).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
                return false;
            }
            if (JavaScriptSupportLoader.isLanguageNamespace((String)descriptor.context.namespace)) {
                String tagName = _descriptor.getName();
                return !descriptor.isPredefined() && !ArrayUtil.contains((String)tagName, (String[])ILLEGAL_LANGUAGE_ROOT_TAGS);
            }
        }
        return true;
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument document) {
        XmlElementDescriptor[] elementDescriptors = CodeContext.getContext(this.namespace, this.module).getDescriptorsWithAllowedDeclaration();
        ArrayList<XmlElementDescriptor> results = new ArrayList<XmlElementDescriptor>(elementDescriptors.length);
        XmlTag rootTag = document == null ? null : document.getRootTag();
        boolean isRootTagCompletion = rootTag != null && rootTag.getName().endsWith("IntellijIdeaRulezzz");
        for (XmlElementDescriptor elementDescriptor : elementDescriptors) {
            String name;
            if (isRootTagCompletion) {
                if (!FlexMxmlNSDescriptor.isLegalRootElementDescriptor(elementDescriptor)) continue;
                if (elementDescriptor instanceof MxmlBackedElementDescriptor) {
                    PsiElement declaration = elementDescriptor.getDeclaration();
                    PsiFile containingFile = document.getContainingFile();
                    if (declaration != null && containingFile != null && declaration.equals(containingFile.getOriginalFile())) continue;
                }
            }
            if ((name = elementDescriptor.getName()).length() <= 0) continue;
            results.add(elementDescriptor);
        }
        XmlElementDescriptor[] xmlElementDescriptorArray = results.toArray(new XmlElementDescriptor[results.size()]);
        if (xmlElementDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/FlexMxmlNSDescriptor", "getRootElementsDescriptors"));
        }
        return xmlElementDescriptorArray;
    }

    @Nullable
    public XmlFile getDescriptorFile() {
        return this.myFile;
    }

    public PsiElement getDeclaration() {
        return this.myFile;
    }

    @NonNls
    public String getName(PsiElement context) {
        return null;
    }

    @NonNls
    public String getName() {
        return null;
    }

    public void init(PsiElement element) {
        XmlDocument document = (XmlDocument)element;
        this.myFile = (XmlFile)document.getContainingFile();
        this.namespace = (String)this.myFile.getUserData(NS_KEY);
        this.module = (Module)this.myFile.getUserData(MODULE_KEY);
        assert (this.namespace != null);
        CodeContextHolder.getInstance(this.module.getProject()).clearCodeContext(this.namespace, this.module);
    }

    @NotNull
    public Object[] getDependences() {
        Object[] objectArray = CodeContext.getContext(this.namespace, this.module).getDependencies();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/FlexMxmlNSDescriptor", "getDependences"));
        }
        return objectArray;
    }

    public void validate(@NotNull XmlDocument context, @NotNull Validator.ValidationHost host) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/mxml/schema/FlexMxmlNSDescriptor", "validate"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/javascript/flex/mxml/schema/FlexMxmlNSDescriptor", "validate"));
        }
    }

    public boolean hasElementDescriptorWithName(String name, String className) {
        CodeContext context = CodeContext.getContext(this.namespace, this.module);
        XmlElementDescriptor descriptor = context.getElementDescriptor(name, (XmlTag)null);
        if (descriptor instanceof ClassBackedElementDescriptor) {
            return ((ClassBackedElementDescriptor)descriptor).className.equals(className);
        }
        return false;
    }

    static {
        ILLEGAL_LANGUAGE_ROOT_TAGS = new String[]{"Array", "Boolean", "Component", "Class", "Date", "DesignLayer", "Function", "Number", "String", "XML", "int", "uint"};
    }
}

