/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.schema.CodeContext;
import com.intellij.javascript.flex.mxml.schema.CodeContextHolder;
import com.intellij.javascript.flex.mxml.schema.FlexMxmlNSDescriptor;
import com.intellij.javascript.flex.resolve.FlexResolveHelper;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlSchemaProvider;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexSchemaHandler
extends XmlSchemaProvider
implements DumbAware {
    private static final Pattern prefixPattern = Pattern.compile("[a-z_][a-z_0-9]*");
    private static final Key<Map<String, ParameterizedCachedValue<XmlFile, Module>>> DESCRIPTORS_MAP_IN_MODULE = Key.create((String)"FLEX_DESCRIPTORS_MAP_IN_MODULE");

    @Nullable
    public XmlFile getSchema(@NotNull @NonNls String url, Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getSchema"));
        }
        return url.length() > 0 && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)baseFile) ? FlexSchemaHandler.getFakeSchemaReference(url, module) : null;
    }

    @Nullable
    private static synchronized XmlFile getFakeSchemaReference(final String uri, @Nullable Module module) {
        if (module == null) {
            return null;
        }
        if (ModuleType.get((Module)module) == FlexModuleType.getInstance() || !CodeContext.isStdNamespace(uri)) {
            ParameterizedCachedValue reference;
            Map descriptors = (Map)module.getUserData(DESCRIPTORS_MAP_IN_MODULE);
            if (descriptors == null) {
                descriptors = new THashMap();
                module.putUserData(DESCRIPTORS_MAP_IN_MODULE, (Object)descriptors);
            }
            if ((reference = (ParameterizedCachedValue)descriptors.get(uri)) == null) {
                reference = CachedValuesManager.getManager((Project)module.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)new ParameterizedCachedValueProvider<XmlFile, Module>(){

                    public CachedValueProvider.Result<XmlFile> compute(Module module) {
                        URL resource = FlexSchemaHandler.class.getResource("z.xsd");
                        VirtualFile fileByURL = VfsUtil.findFileByURL((URL)resource);
                        XmlFile result = (XmlFile)PsiManager.getInstance((Project)module.getProject()).findFile(fileByURL).copy();
                        result.putUserData(FlexMxmlNSDescriptor.NS_KEY, (Object)uri);
                        result.putUserData(FlexMxmlNSDescriptor.MODULE_KEY, (Object)module);
                        return new CachedValueProvider.Result((Object)result, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                    }
                }, false);
                descriptors.put(uri, reference);
            }
            assert (!module.getProject().isDisposed()) : module.getProject() + " already disposed";
            return (XmlFile)reference.getValue((Object)module);
        }
        return null;
    }

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "isAvailable"));
        }
        return JavaScriptSupportLoader.isFlexMxmFile((PsiFile)file);
    }

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile _file, final @Nullable @NonNls String tagName) {
        if (_file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_file", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getAvailableNamespaces"));
        }
        PsiFile originalFile = _file.getOriginalFile();
        if (originalFile instanceof XmlFile) {
            _file = (XmlFile)originalFile;
        }
        XmlFile file = _file;
        Project project = file.getProject();
        Module module = ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(file.getVirtualFile());
        Collection<String> illegalNamespaces = FlexSchemaHandler.getIllegalNamespaces(file);
        THashSet result = new THashSet();
        THashSet componentsThatHaveNotPackageBackedNamespace = new THashSet();
        for (String namespace : CodeContextHolder.getInstance(project).getNamespaces(module)) {
            if (CodeContext.isPackageBackedNamespace(namespace) || illegalNamespaces.contains(namespace)) continue;
            if (tagName == null) {
                result.add(namespace);
                continue;
            }
            XmlElementDescriptor descriptor = CodeContext.getContext(namespace, module).getElementDescriptor(tagName, (XmlTag)null);
            if (descriptor == null) continue;
            result.add(namespace);
            componentsThatHaveNotPackageBackedNamespace.add(descriptor.getQualifiedName());
        }
        if (tagName == null && !illegalNamespaces.contains("http://www.adobe.com/2006/mxml")) {
            result.add("http://www.adobe.com/2006/mxml");
        }
        if ("Script".equals(tagName) || "Style".equals(tagName)) {
            THashSet tHashSet = result;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getAvailableNamespaces"));
            }
            return tHashSet;
        }
        if (DumbService.isDumb((Project)project)) {
            THashSet tHashSet = result;
            if (tHashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getAvailableNamespaces"));
            }
            return tHashSet;
        }
        if (tagName == null) {
            FileBasedIndex.getInstance().processAllKeys(JSPackageIndex.INDEX_ID, arg_0 -> FlexSchemaHandler.lambda$getAvailableNamespaces$0((Set)result, arg_0), project);
        } else {
            GlobalSearchScope scopeWithLibs = module != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
            for (JSQualifiedNamedElement element : JSResolveUtil.findElementsByName((String)tagName, (Project)project, (GlobalSearchScope)scopeWithLibs, (boolean)false)) {
                String packageName;
                if (!(element instanceof JSClass) || !CodeContext.hasDefaultConstructor((JSClass)element) || componentsThatHaveNotPackageBackedNamespace.contains(StringUtil.getQualifiedName((String)(packageName = StringUtil.getPackageName((String)element.getQualifiedName())), (String)tagName))) continue;
                result.add(StringUtil.isEmpty((String)packageName) ? "*" : packageName + ".*");
            }
        }
        GlobalSearchScope scopeWithoutLibs = module != null ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.allScope((Project)project);
        FlexResolveHelper.processAllMxmlAndFxgFiles(scopeWithoutLibs, project, new FlexResolveHelper.MxmlAndFxgFilesProcessor((Set)componentsThatHaveNotPackageBackedNamespace, (Set)result){
            final /* synthetic */ Set val$componentsThatHaveNotPackageBackedNamespace;
            final /* synthetic */ Set val$result;
            {
                this.val$componentsThatHaveNotPackageBackedNamespace = set;
                this.val$result = set2;
            }

            @Override
            public void addDependency(PsiDirectory directory) {
            }

            @Override
            public boolean processFile(VirtualFile file, VirtualFile root) {
                String packageName;
                if (!(tagName != null && !tagName.equals(file.getNameWithoutExtension()) || (packageName = VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)root, (char)'.')) == null || tagName != null && this.val$componentsThatHaveNotPackageBackedNamespace.contains(StringUtil.getQualifiedName((String)packageName, (String)tagName)))) {
                    this.val$result.add(StringUtil.isEmpty((String)packageName) ? "*" : packageName + ".*");
                }
                return true;
            }
        }, tagName);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getAvailableNamespaces"));
        }
        return tHashSet;
    }

    private static Collection<String> getIllegalNamespaces(XmlFile file) {
        XmlDocument document = file.getDocument();
        XmlTag rootTag = document == null ? null : document.getRootTag();
        String[] knownNamespaces = rootTag == null ? null : rootTag.knownNamespaces();
        ArrayList<String> illegalNamespaces = new ArrayList<String>();
        if (knownNamespaces != null) {
            if (ArrayUtil.contains((String)"http://www.adobe.com/2006/mxml", (String[])knownNamespaces)) {
                ContainerUtil.addAll(illegalNamespaces, (Object[])MxmlJSClass.FLEX_4_NAMESPACES);
            } else if (ArrayUtil.contains((String)"http://ns.adobe.com/mxml/2009", (String[])knownNamespaces)) {
                illegalNamespaces.add("http://www.adobe.com/2006/mxml");
            }
        }
        return illegalNamespaces;
    }

    public String getDefaultPrefix(@NotNull @NonNls String namespace, @NotNull XmlFile context) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getDefaultPrefix"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getDefaultPrefix"));
        }
        return FlexSchemaHandler.getUniquePrefix(namespace, context);
    }

    static String getUniquePrefix(String namespace, XmlFile xmlFile) {
        XmlDocument document;
        XmlTag tag;
        String[] knownPrefixes;
        String prefix = FlexSchemaHandler.getDefaultPrefix(namespace);
        if (ArrayUtil.contains((String)prefix, (String[])(knownPrefixes = FlexSchemaHandler.getKnownPrefixes(tag = (document = xmlFile.getDocument()) == null ? null : document.getRootTag())))) {
            int i = 2;
            while (true) {
                String newPrefix;
                if (!ArrayUtil.contains((String)(newPrefix = prefix + i), (String[])knownPrefixes)) {
                    prefix = newPrefix;
                    break;
                }
                ++i;
            }
        }
        return prefix;
    }

    public static String getDefaultPrefix(@NotNull @NonNls String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/javascript/flex/mxml/schema/FlexSchemaHandler", "getDefaultPrefix"));
        }
        if ("http://www.adobe.com/2006/mxml".equals(namespace)) {
            return "mx";
        }
        if ("http://ns.adobe.com/mxml/2009".equals(namespace)) {
            return "fx";
        }
        if ("library://ns.adobe.com/flex/spark".equals(namespace)) {
            return "s";
        }
        if ("library://ns.adobe.com/flex/halo".equals(namespace)) {
            return "h";
        }
        if ("library://ns.adobe.com/flex/mx".equals(namespace)) {
            return "mx";
        }
        if ("*".equals(namespace)) {
            return "local";
        }
        String prefix = namespace = FileUtil.toSystemIndependentName((String)namespace.toLowerCase());
        if (namespace.endsWith(".*") && namespace.length() > 2) {
            String pack = namespace.substring(0, namespace.length() - 2);
            prefix = pack.substring(pack.lastIndexOf(46) + 1);
        } else {
            String schemaMarker = "://";
            int schemaMarkerIndex = namespace.indexOf("://");
            if (schemaMarkerIndex > 0) {
                int endIndex;
                String path = namespace.substring(schemaMarkerIndex + "://".length());
                path = StringUtil.trimStart((String)path, (String)"www.");
                String lastSegment = (path = StringUtil.trimEnd((String)path, (String)"/")).substring(path.lastIndexOf(47) + 1);
                if (prefixPattern.matcher(lastSegment).matches()) {
                    return lastSegment;
                }
                int dotIndex = path.indexOf(46);
                int slashIndex = path.indexOf(47);
                int n = dotIndex == -1 ? (slashIndex == -1 ? path.length() : slashIndex) : (endIndex = slashIndex == -1 ? dotIndex : Math.min(dotIndex, slashIndex));
                if (path.length() > 0 && endIndex > 0) {
                    prefix = path.substring(0, endIndex);
                }
            }
        }
        if (prefix != null && prefixPattern.matcher(prefix).matches()) {
            return prefix;
        }
        return "undefined";
    }

    private static String[] getKnownPrefixes(XmlTag tag) {
        String[] namespaces;
        String[] stringArray = namespaces = tag == null ? null : tag.knownNamespaces();
        if (namespaces != null && namespaces.length > 0) {
            String[] knownPrefixes = new String[namespaces.length];
            for (int i = 0; i < namespaces.length; ++i) {
                knownPrefixes[i] = tag.getPrefixByNamespace(namespaces[i]);
            }
            return knownPrefixes;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    private static /* synthetic */ boolean lambda$getAvailableNamespaces$0(Set result, String packageName) {
        result.add(StringUtil.isEmpty((String)packageName) ? "*" : packageName + ".*");
        return true;
    }
}

