/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.ProjectTopics;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.lang.javascript.flex.FlexUtils;
import com.intellij.lang.javascript.flex.build.FlexCompilationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCompilerDependenciesCache {
    private final Project myProject;
    private final Map<Module, Collection<BCInfo>> myCache = new THashMap();
    private static final String[] TAGS_FOR_FILE_PATHS_IN_CONFIG_FILE = new String[]{"<flex-config><compiler><external-library-path><path-element>", "<flex-config><compiler><local-font-paths><path-element>", "<flex-config><compiler><library-path><path-element>", "<flex-config><compiler><namespaces><namespace><manifest>", "<flex-config><compiler><theme><filename>", "<flex-config><include-file><path>", "<flex-config><include-stylesheet><path>", "<flex-config><file-specs><path-element>", "<flex-config><compiler><include-libraries><library>", "<flex-config><compiler><local-fonts-snapshot>", "<flex-config><compiler><defaults-css-url>", "<flex-config><compiler><defaults-css-files><filename>", "<flex-config><load-config>", "<flex-config><load-externs>", "<flex-config><link-report>", "<flex-config><services>", "<flex-config><metadata><raw-metadata>"};

    public FlexCompilerDependenciesCache(Project project) {
        this.myProject = project;
        project.getMessageBus().connect((Disposable)project).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/build/FlexCompilerDependenciesCache$1", "moduleRemoved"));
                }
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/build/FlexCompilerDependenciesCache$1", "moduleRemoved"));
                }
                FlexCompilerDependenciesCache.this.myCache.remove(module);
            }
        });
    }

    public void clear() {
        this.myCache.clear();
    }

    public void markModuleDirty(Module module) {
        this.myCache.remove(module);
    }

    public void markBCDirty(Module module, FlexBuildConfiguration bc) {
        BCInfo existingInfo;
        Collection<BCInfo> infosForModule = this.myCache.get(module);
        BCInfo bCInfo = existingInfo = infosForModule == null ? null : FlexCompilerDependenciesCache.findCacheForBC(infosForModule, bc);
        if (existingInfo != null) {
            infosForModule.remove(existingInfo);
            if (infosForModule.isEmpty()) {
                this.myCache.remove(module);
            }
        }
    }

    public void markModuleDirtyIfInSourceRoot(VirtualFile file) {
        if (this.myCache.isEmpty()) {
            return;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        Module module = fileIndex.getModuleForFile(file);
        if (module != null && fileIndex.getSourceRootForFile(file) != null && !fileIndex.isInTestSourceContent(file)) {
            this.markModuleDirty(module);
        }
    }

    public boolean isNothingChangedSincePreviousCompilation(Module module, FlexBuildConfiguration bc) {
        BCInfo existingInfo;
        Collection<BCInfo> infosForModule = this.myCache.get(module);
        BCInfo bCInfo = existingInfo = infosForModule == null ? null : FlexCompilerDependenciesCache.findCacheForBC(infosForModule, bc);
        if (existingInfo == null) {
            return false;
        }
        Object[] currentSourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRootUrls();
        if (!Arrays.equals(existingInfo.mySourceRootUrls, currentSourceRoots) || existingInfo.timestampsChanged()) {
            infosForModule.remove(existingInfo);
            if (infosForModule.isEmpty()) {
                this.myCache.remove(module);
            }
            return false;
        }
        return true;
    }

    public void cacheBC(Module module, FlexBuildConfiguration bc, List<VirtualFile> configFiles) {
        BuildConfigurationNature nature;
        Collection<BCInfo> infosForModule = this.myCache.get(module);
        if (infosForModule == null) {
            infosForModule = new ArrayList<BCInfo>();
            this.myCache.put(module, infosForModule);
        } else {
            BCInfo existingInfo = FlexCompilerDependenciesCache.findCacheForBC(infosForModule, bc);
            if (existingInfo != null) {
                infosForModule.remove(existingInfo);
            }
        }
        VirtualFile outputFile = FlexCompilationManager.refreshAndFindFileInWriteAction(bc.getActualOutputFilePath(), new String[0]);
        if (outputFile == null) {
            return;
        }
        BCInfo bcInfo = new BCInfo(Factory.getCopy(bc), ModuleRootManager.getInstance((Module)module).getSourceRootUrls());
        infosForModule.add(bcInfo);
        bcInfo.addFileDependency(outputFile.getPath(), new String[0]);
        String workDirPath = FlexUtils.getFlexCompilerWorkDirPath(module.getProject(), null);
        for (VirtualFile configFile : configFiles) {
            FlexCompilerDependenciesCache.addFileDependencies(bcInfo, configFile, workDirPath);
        }
        if (bc.isTempBCForCompilation() && !bc.getCompilerOptions().getAdditionalConfigFilePath().isEmpty()) {
            bcInfo.addFileDependency(bc.getCompilerOptions().getAdditionalConfigFilePath(), new String[0]);
        }
        if ((nature = bc.getNature()).isApp() && !nature.isWebPlatform()) {
            if (nature.isDesktopPlatform()) {
                if (!bc.getAirDesktopPackagingOptions().isUseGeneratedDescriptor()) {
                    bcInfo.addFileDependency(bc.getAirDesktopPackagingOptions().getCustomDescriptorPath(), new String[0]);
                }
            } else {
                if (bc.getAndroidPackagingOptions().isEnabled() && !bc.getAndroidPackagingOptions().isUseGeneratedDescriptor()) {
                    bcInfo.addFileDependency(bc.getAndroidPackagingOptions().getCustomDescriptorPath(), new String[0]);
                }
                if (bc.getIosPackagingOptions().isEnabled() && !bc.getIosPackagingOptions().isUseGeneratedDescriptor()) {
                    bcInfo.addFileDependency(bc.getIosPackagingOptions().getCustomDescriptorPath(), new String[0]);
                }
            }
        }
    }

    @Nullable
    private static BCInfo findCacheForBC(@NotNull Collection<BCInfo> bcInfos, @NotNull FlexBuildConfiguration bc) {
        if (bcInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcInfos", "com/intellij/lang/javascript/flex/build/FlexCompilerDependenciesCache", "findCacheForBC"));
        }
        if (bc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/build/FlexCompilerDependenciesCache", "findCacheForBC"));
        }
        return (BCInfo)ContainerUtil.find(bcInfos, info -> {
            if (bc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bc", "com/intellij/lang/javascript/flex/build/FlexCompilerDependenciesCache", "lambda$findCacheForBC$0"));
            }
            return ((BCInfo)info).myBC.isEqual(bc);
        });
    }

    private static void addFileDependencies(BCInfo bcInfo, VirtualFile configFile, String workDirPath) {
        bcInfo.addFileDependency(configFile.getPath(), new String[0]);
        try {
            Map<String, List<String>> elementsMap = FlexUtils.findXMLElements(configFile.getInputStream(), Arrays.asList(TAGS_FOR_FILE_PATHS_IN_CONFIG_FILE));
            for (List<String> filePathList : elementsMap.values()) {
                for (String filePath : filePathList) {
                    bcInfo.addFileDependency(filePath, new String[]{configFile.getParent().getPath(), workDirPath});
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class BCInfo {
        private final FlexBuildConfiguration myBC;
        private final String[] mySourceRootUrls;
        private final Collection<Pair<File, Long>> myFileToTimestamp = new ArrayList<Pair<File, Long>>();

        private BCInfo(FlexBuildConfiguration bc, String[] sourceRootUrls) {
            this.myBC = bc;
            this.mySourceRootUrls = sourceRootUrls;
        }

        private void addFileDependency(String filePath, String ... potentialBaseDirs) {
            File file = new File(FileUtil.toSystemDependentName((String)filePath));
            if (file.exists()) {
                this.myFileToTimestamp.add((Pair<File, Long>)Pair.create((Object)file, (Object)file.lastModified()));
            } else if (potentialBaseDirs != null) {
                for (String baseDir : potentialBaseDirs) {
                    File file1 = new File(FileUtil.toSystemDependentName((String)(baseDir + '/' + filePath)));
                    if (!file1.exists()) continue;
                    this.myFileToTimestamp.add((Pair<File, Long>)Pair.create((Object)file1, (Object)file1.lastModified()));
                    break;
                }
            }
        }

        public boolean timestampsChanged() {
            for (Pair<File, Long> fileAndTimestamp : this.myFileToTimestamp) {
                if (((File)fileAndTimestamp.first).lastModified() == ((Long)fileAndTimestamp.second).longValue()) continue;
                return true;
            }
            return false;
        }
    }
}

