/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.ProjectTopics;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleOrProjectCompilerOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.CompilerOptionsImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexBuildConfigurationState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="FlexBuildConfigurationManager")
public class FlexBuildConfigurationManagerImpl
extends FlexBuildConfigurationManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)FlexBuildConfigurationManagerImpl.class.getName());
    public static final String COMPONENT_NAME = "FlexBuildConfigurationManager";
    @Nullable
    private final Module myModule;
    private FlexBuildConfigurationImpl[] myConfigurations = new FlexBuildConfigurationImpl[]{new FlexBuildConfigurationImpl()};
    private final CompilerOptionsImpl myModuleLevelCompilerOptions;
    private FlexBuildConfigurationImpl myActiveConfiguration = this.myConfigurations[0];

    public FlexBuildConfigurationManagerImpl(@Nullable Module module) {
        this.myModule = module;
        CompilerOptionsImpl compilerOptionsImpl = this.myModuleLevelCompilerOptions = module == null ? new CompilerOptionsImpl() : new CompilerOptionsImpl(module.getProject(), true);
        if (this.myModule != null) {
            this.myModule.getProject().getMessageBus().connect((Disposable)this.myModule).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationManagerImpl$1", "beforeModuleRemoved"));
                    }
                    if (module == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/model/impl/FlexBuildConfigurationManagerImpl$1", "beforeModuleRemoved"));
                    }
                    if (module != FlexBuildConfigurationManagerImpl.this.myModule) {
                        FlexBuildConfigurationManagerImpl.this.removeDependenciesOn(module);
                    }
                }
            });
        }
    }

    private void removeDependenciesOn(Module module) {
        for (FlexBuildConfigurationImpl configuration : this.myConfigurations) {
            Iterator<ModifiableDependencyEntry> i = configuration.getDependencies().getModifiableEntries().iterator();
            while (i.hasNext()) {
                DependencyEntry entry = i.next();
                if (!(entry instanceof BuildConfigurationEntry) || ((BuildConfigurationEntry)entry).findModule() != module) continue;
                i.remove();
            }
        }
    }

    @Override
    @Nullable
    public FlexBuildConfiguration findConfigurationByName(String name) {
        for (FlexBuildConfigurationImpl configuration : this.myConfigurations) {
            if (!configuration.getName().equals(name)) continue;
            return configuration;
        }
        return null;
    }

    @Override
    public FlexBuildConfiguration getActiveConfiguration() {
        return this.myActiveConfiguration;
    }

    @Override
    public void setActiveBuildConfiguration(FlexBuildConfiguration buildConfiguration) {
        if (this.myActiveConfiguration == buildConfiguration) {
            return;
        }
        if (!ArrayUtil.contains((Object)buildConfiguration, (Object[])this.myConfigurations)) {
            throw new IllegalArgumentException("Build configuration " + buildConfiguration.getName() + " does not belong to module " + (this.myModule != null ? this.myModule.getName() : "(dummy)"));
        }
        if (this.myModule != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                this.myActiveConfiguration = (FlexBuildConfigurationImpl)buildConfiguration;
                FlexBuildConfigurationManagerImpl.resetHighlighting(this.myModule.getProject());
            });
        } else {
            this.myActiveConfiguration = (FlexBuildConfigurationImpl)buildConfiguration;
        }
    }

    @Override
    public FlexBuildConfiguration[] getBuildConfigurations() {
        return Arrays.copyOf(this.myConfigurations, this.myConfigurations.length);
    }

    FlexBuildConfigurationImpl[] doGetBuildConfigurations() {
        return this.myConfigurations;
    }

    @Override
    public ModuleOrProjectCompilerOptions getModuleLevelCompilerOptions() {
        return this.myModuleLevelCompilerOptions;
    }

    void setBuildConfigurations(FlexBuildConfigurationImpl[] configurations) {
        String activeName = this.myActiveConfiguration != null ? this.myActiveConfiguration.getName() : null;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        FlexBuildConfigurationImpl[] validatedConfigurations = this.getValidatedConfigurations(Arrays.asList(configurations));
        this.doSetBuildConfigurations(validatedConfigurations);
        this.updateActiveConfiguration(activeName);
    }

    void doSetBuildConfigurations(FlexBuildConfigurationImpl[] configurations) {
        this.myConfigurations = configurations;
    }

    private void updateActiveConfiguration(@Nullable String activeName) {
        if (this.myConfigurations.length > 0) {
            FlexBuildConfigurationImpl flexBuildConfigurationImpl = this.myActiveConfiguration = activeName != null ? (FlexBuildConfigurationImpl)ContainerUtil.find((Object[])this.myConfigurations, bc -> bc.getName().equals(activeName)) : null;
            if (this.myActiveConfiguration == null) {
                this.myActiveConfiguration = this.myConfigurations[0];
            }
        } else {
            this.myActiveConfiguration = null;
        }
    }

    public State getState() {
        State state = new State();
        for (FlexBuildConfigurationImpl configuration : this.myConfigurations) {
            state.CONFIGURATIONS.add(configuration.getState((ComponentManager)this.myModule));
        }
        state.myModuleLevelCompilerOptions = this.myModuleLevelCompilerOptions.getState((ComponentManager)this.myModule);
        state.myActiveConfigurationName = this.myActiveConfiguration != null ? this.myActiveConfiguration.getName() : null;
        return state;
    }

    public void loadState(State state) {
        if (this.myModule == null) {
            throw new IllegalStateException("Cannot load state of a dummy config manager instance");
        }
        ArrayList<FlexBuildConfigurationImpl> configurations = new ArrayList<FlexBuildConfigurationImpl>(state.CONFIGURATIONS.size());
        for (FlexBuildConfigurationState configurationState : state.CONFIGURATIONS) {
            FlexBuildConfigurationImpl configuration = new FlexBuildConfigurationImpl();
            configuration.loadState(configurationState, this.myModule.getProject());
            configurations.add(configuration);
        }
        this.doSetBuildConfigurations(this.getValidatedConfigurations(configurations));
        this.updateActiveConfiguration(state.myActiveConfigurationName);
        this.myModuleLevelCompilerOptions.loadState(state.myModuleLevelCompilerOptions);
    }

    static void resetHighlighting(Project project) {
        ProjectRootManagerEx.getInstanceEx((Project)project).makeRootsChange(EmptyRunnable.getInstance(), false, true);
    }

    /*
     * WARNING - void declaration
     */
    private FlexBuildConfigurationImpl[] getValidatedConfigurations(Collection<? extends FlexBuildConfigurationImpl> configurations) {
        void var4_7;
        if (configurations.isEmpty()) {
            LOG.warn("No Flash build configurations found");
            return new FlexBuildConfigurationImpl[]{new FlexBuildConfigurationImpl()};
        }
        ArrayList<? extends FlexBuildConfigurationImpl> configList = new ArrayList<FlexBuildConfigurationImpl>(configurations);
        for (FlexBuildConfigurationImpl flexBuildConfigurationImpl : configList) {
            if (!StringUtil.isEmpty((String)flexBuildConfigurationImpl.getName())) continue;
            LOG.warn("Empty build configuration name");
            flexBuildConfigurationImpl.setName(this.myModule.getName());
        }
        HashSet<String> names = new HashSet<String>();
        Object var4_5 = null;
        for (FlexBuildConfiguration flexBuildConfiguration : configList) {
            if (StringUtil.isEmpty((String)flexBuildConfiguration.getName())) {
                LOG.warn("Empty build configuration name");
                continue;
            }
            if (names.add(flexBuildConfiguration.getName())) continue;
            String string = flexBuildConfiguration.getName();
            break;
        }
        if (var4_7 != null) {
            void var6_11;
            LOG.warn("Duplicate build configuration name: " + (String)var4_7);
            List<String> uniqueNames = FlexBuildConfigurationManagerImpl.generateUniqueNames(ContainerUtil.map2List(configList, bc -> bc.getName()));
            boolean bl = false;
            while (var6_11 < configList.size()) {
                ((FlexBuildConfigurationImpl)configList.get((int)var6_11)).setName(uniqueNames.get((int)var6_11));
                ++var6_11;
            }
        }
        return configList.toArray(new FlexBuildConfigurationImpl[configList.size()]);
    }

    public static List<String> generateUniqueNames(List<String> names) {
        ArrayList<String> result = new ArrayList<String>(names.size());
        HashSet<String> namesBefore = new HashSet<String>();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            String newName = name;
            if (namesBefore.contains(newName)) {
                HashSet<String> otherNames = new HashSet<String>(namesBefore);
                otherNames.addAll(names.subList(i + 1, names.size()));
                int index = 1;
                while (otherNames.contains(newName = MessageFormat.format("{0} ({1})", name, index++))) {
                }
            }
            result.add(newName);
            namesBefore.add(newName);
        }
        return result;
    }

    public static class State {
        @Tag(value="configurations")
        @AbstractCollection(surroundWithTag=false, elementTag="configuration")
        public List<FlexBuildConfigurationState> CONFIGURATIONS = new ArrayList<FlexBuildConfigurationState>();
        @Property(surroundWithTag=false)
        public CompilerOptionsImpl.State myModuleLevelCompilerOptions = new CompilerOptionsImpl.State();
        @Attribute(value="active")
        public String myActiveConfigurationName;
    }
}

