/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfigurationManager;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunConfigurationType;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FlashRunConfigurationProducer
extends RunConfigurationProducer<FlashRunConfiguration> {
    public FlashRunConfigurationProducer() {
        super((ConfigurationType)FlashRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(FlashRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Module module = context.getModule();
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return false;
        }
        JSClass jsClass = FlashRunConfigurationProducer.getJSClass(context.getPsiLocation());
        if (jsClass == null || !FlashRunConfigurationProducer.isAcceptedMainClass(jsClass, module)) {
            return false;
        }
        FlashRunnerParameters params = configuration.getRunnerParameters();
        params.setModuleName(module.getName());
        FlexBuildConfiguration bc = FlashRunConfigurationProducer.getBCToBaseOn(module, jsClass.getQualifiedName());
        params.setBCName(bc.getName());
        if (bc.getOutputType() == OutputType.Application && jsClass.getQualifiedName().equals(bc.getMainClass())) {
            params.setOverrideMainClass(false);
        } else {
            params.setOverrideMainClass(true);
            params.setOverriddenMainClass(jsClass.getQualifiedName());
            params.setOverriddenOutputFileName(jsClass.getName() + ".swf");
        }
        if (bc.getTargetPlatform() == TargetPlatform.Mobile && bc.getOutputType() == OutputType.Application && params.getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.Emulator) {
            if (params.getAppDescriptorForEmulator() == FlashRunnerParameters.AppDescriptorForEmulator.Android && !bc.getAndroidPackagingOptions().isEnabled() && bc.getIosPackagingOptions().isEnabled()) {
                params.setAppDescriptorForEmulator(FlashRunnerParameters.AppDescriptorForEmulator.IOS);
            }
            if (params.getAppDescriptorForEmulator() == FlashRunnerParameters.AppDescriptorForEmulator.IOS && bc.getAndroidPackagingOptions().isEnabled() && !bc.getIosPackagingOptions().isEnabled()) {
                params.setAppDescriptorForEmulator(FlashRunnerParameters.AppDescriptorForEmulator.Android);
            }
        }
        configuration.setGeneratedName();
        return true;
    }

    public boolean isConfigurationFromContext(FlashRunConfiguration configuration, ConfigurationContext context) {
        Module module = context.getModule();
        if (module == null || ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return false;
        }
        if (!module.getName().equals(configuration.getRunnerParameters().getModuleName())) {
            return false;
        }
        JSClass jsClass = FlashRunConfigurationProducer.getJSClass(context.getPsiLocation());
        if (jsClass == null || !FlashRunConfigurationProducer.isAcceptedMainClass(jsClass, module)) {
            return false;
        }
        List existing = RunManager.getInstance((Project)module.getProject()).getConfigurationsList(this.getConfigurationType());
        RunConfiguration suitable = FlashRunConfigurationProducer.findSuitableRunConfig(module, jsClass.getQualifiedName(), existing);
        return suitable == configuration;
    }

    private static FlexBuildConfiguration getBCToBaseOn(Module module, String fqn) {
        FlexBuildConfigurationManager manager = FlexBuildConfigurationManager.getInstance(module);
        FlexBuildConfiguration appWithSuitableMainClass = null;
        for (FlexBuildConfiguration bc : manager.getBuildConfigurations()) {
            if (bc.getOutputType() != OutputType.Application || !fqn.equals(bc.getMainClass())) continue;
            if (manager.getActiveConfiguration() == bc) {
                return bc;
            }
            appWithSuitableMainClass = bc;
        }
        return appWithSuitableMainClass != null ? appWithSuitableMainClass : manager.getActiveConfiguration();
    }

    @Nullable
    private static RunConfiguration findSuitableRunConfig(Module module, String fqn, List<RunConfiguration> existing) {
        FlexBuildConfigurationManager manager = FlexBuildConfigurationManager.getInstance(module);
        RunConfiguration basedOnBC = null;
        RunConfiguration basedOnMainClass = null;
        RunConfiguration basedOnMainClassAndActiveBC = null;
        for (RunConfiguration runConfig : existing) {
            FlexBuildConfiguration bc;
            FlashRunnerParameters params = ((FlashRunConfiguration)runConfig).getRunnerParameters();
            if (!module.getName().equals(params.getModuleName()) || (bc = manager.findConfigurationByName(params.getBCName())) == null) continue;
            if (params.isOverrideMainClass()) {
                if (!fqn.equals(params.getOverriddenMainClass())) continue;
                if (manager.getActiveConfiguration() == bc) {
                    basedOnMainClassAndActiveBC = runConfig;
                }
                basedOnMainClass = runConfig;
                continue;
            }
            if (bc.getOutputType() != OutputType.Application || !fqn.equals(bc.getMainClass())) continue;
            if (manager.getActiveConfiguration() == bc) {
                return runConfig;
            }
            basedOnBC = runConfig;
        }
        return basedOnBC != null ? basedOnBC : (basedOnMainClassAndActiveBC != null ? basedOnMainClassAndActiveBC : basedOnMainClass);
    }

    @Nullable
    private static JSClass getJSClass(@Nullable PsiElement sourceElement) {
        PsiElement element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)sourceElement, (Class[])new Class[]{JSClass.class, JSFile.class, XmlFile.class});
        if (element instanceof JSFile) {
            element = JSPsiImplUtils.findClass((JSFile)((JSFile)element));
        } else if (element instanceof XmlFile) {
            element = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element));
        }
        return element instanceof JSClass ? (JSClass)element : null;
    }

    public static boolean isAcceptedMainClass(@Nullable JSClass jsClass, @Nullable Module module) {
        return jsClass != null && module != null && BCUtils.isValidMainClass(module, null, jsClass, true);
    }
}

