/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.lang.javascript.flex.FlexRefactoringListenerProvider;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import org.jetbrains.annotations.NotNull;

public abstract class FlexRunConfigRefactoringListener
extends RefactoringElementAdapter {
    protected final RunConfigurationBase myRunConfiguration;

    public FlexRunConfigRefactoringListener(RunConfigurationBase runConfiguration) {
        assert (runConfiguration instanceof FlashRunConfiguration || runConfiguration instanceof FlexUnitRunConfiguration) : runConfiguration.getType().getDisplayName();
        this.myRunConfiguration = runConfiguration;
    }

    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener", "elementRenamedOrMoved"));
        }
        this.updateParams(newElement);
    }

    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener", "undoElementMovedOrRenamed"));
        }
        if (oldQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener", "undoElementMovedOrRenamed"));
        }
        this.undo(newElement, oldQualifiedName);
    }

    protected abstract void updateParams(PsiElement var1);

    protected abstract void undo(PsiElement var1, String var2);

    private static void updatePackage(RunConfigurationBase runConfiguration, String newPackage) {
        if (runConfiguration instanceof FlexUnitRunConfiguration) {
            FlexUnitRunnerParameters params = ((FlexUnitRunConfiguration)runConfiguration).getRunnerParameters();
            if (params.getScope() == FlexUnitRunnerParameters.Scope.Package) {
                params.setPackageName(newPackage);
            } else {
                String oldFqn = params.getClassName();
                params.setClassName(StringUtil.getQualifiedName((String)newPackage, (String)StringUtil.getShortName((String)oldFqn)));
            }
        } else {
            FlashRunnerParameters params = ((FlashRunConfiguration)runConfiguration).getRunnerParameters();
            String oldFqn = params.getOverriddenMainClass();
            params.setOverriddenMainClass(StringUtil.getQualifiedName((String)newPackage, (String)StringUtil.getShortName((String)oldFqn)));
        }
    }

    public static class PackageRefactoringListener
    extends FlexRunConfigRefactoringListener {
        public PackageRefactoringListener(RunConfigurationBase runConfiguration) {
            super(runConfiguration);
        }

        @Override
        protected void updateParams(PsiElement newElement) {
            if (newElement instanceof PsiDirectoryContainer) {
                FlexRunConfigRefactoringListener.updatePackage(this.myRunConfiguration, FlexRefactoringListenerProvider.getPackageName(newElement));
            } else if (newElement instanceof JSPackage || newElement instanceof JSPackageStatement) {
                FlexRunConfigRefactoringListener.updatePackage(this.myRunConfiguration, ((JSQualifiedNamedElement)newElement).getQualifiedName());
            }
        }

        @Override
        public void undo(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$PackageRefactoringListener", "undo"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$PackageRefactoringListener", "undo"));
            }
            FlexRunConfigRefactoringListener.updatePackage(this.myRunConfiguration, oldQualifiedName);
        }
    }

    public static class JSFunctionRefactoringListener
    extends FlexRunConfigRefactoringListener {
        public JSFunctionRefactoringListener(FlexUnitRunConfiguration runConfiguration) {
            super((RunConfigurationBase)runConfiguration);
        }

        @Override
        protected void updateParams(PsiElement newElement) {
            if (!(newElement instanceof JSFunction)) {
                return;
            }
            String newName = ((JSFunction)newElement).getName();
            if (newName != null && StringUtil.isNotEmpty((String)newName)) {
                ((FlexUnitRunConfiguration)this.myRunConfiguration).getRunnerParameters().setMethodName(newName);
            }
        }

        @Override
        public void undo(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$JSFunctionRefactoringListener", "undo"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$JSFunctionRefactoringListener", "undo"));
            }
            int methodIdx = oldQualifiedName.lastIndexOf(".") + 1;
            if (methodIdx > 0 && methodIdx < oldQualifiedName.length()) {
                ((FlexUnitRunConfiguration)this.myRunConfiguration).getRunnerParameters().setMethodName(oldQualifiedName.substring(methodIdx));
            }
        }
    }

    public static class PsiDirectoryRefactoringListener
    extends FlexRunConfigRefactoringListener {
        public PsiDirectoryRefactoringListener(RunConfigurationBase runConfiguration) {
            super(runConfiguration);
        }

        @Override
        protected void updateParams(PsiElement newElement) {
            if (!(newElement instanceof PsiDirectory)) {
                return;
            }
            FlexRunConfigRefactoringListener.updatePackage(this.myRunConfiguration, DirectoryIndex.getInstance((Project)newElement.getProject()).getPackageName(((PsiDirectory)newElement).getVirtualFile()));
        }

        @Override
        public void undo(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$PsiDirectoryRefactoringListener", "undo"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$PsiDirectoryRefactoringListener", "undo"));
            }
            FlexRunConfigRefactoringListener.updatePackage(this.myRunConfiguration, oldQualifiedName);
        }
    }

    public static class JSClassRefactoringListener
    extends FlexRunConfigRefactoringListener {
        public JSClassRefactoringListener(RunConfigurationBase runConfiguration) {
            super(runConfiguration);
        }

        @Override
        protected void updateParams(PsiElement newElement) {
            JSClass newClass = FlexRefactoringListenerProvider.getJSClass(newElement);
            if (newClass == null) {
                return;
            }
            String qName = newClass.getQualifiedName();
            if (StringUtil.isNotEmpty((String)qName)) {
                if (this.myRunConfiguration instanceof FlexUnitRunConfiguration) {
                    ((FlexUnitRunConfiguration)this.myRunConfiguration).getRunnerParameters().setClassName(qName);
                } else {
                    ((FlashRunConfiguration)this.myRunConfiguration).getRunnerParameters().setOverriddenMainClass(qName);
                }
            }
        }

        @Override
        public void undo(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$JSClassRefactoringListener", "undo"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/intellij/lang/javascript/flex/run/FlexRunConfigRefactoringListener$JSClassRefactoringListener", "undo"));
            }
            if (this.myRunConfiguration instanceof FlexUnitRunConfiguration) {
                ((FlexUnitRunConfiguration)this.myRunConfiguration).getRunnerParameters().setClassName(oldQualifiedName);
            } else {
                ((FlashRunConfiguration)this.myRunConfiguration).getRunnerParameters().setOverriddenMainClass(oldQualifiedName);
            }
        }
    }
}

