/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunConfigurationForm;
import com.intellij.lang.javascript.flex.run.RemoteFlashRunnerParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RemoteFlashRunConfiguration
extends LocatableConfigurationBase {
    private static final String DEFAULT_NAME = "Remote debug";
    private RemoteFlashRunnerParameters myRunnerParameters = new RemoteFlashRunnerParameters();

    public RemoteFlashRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public RemoteFlashRunConfiguration clone() {
        RemoteFlashRunConfiguration clone = (RemoteFlashRunConfiguration)super.clone();
        clone.myRunnerParameters = this.myRunnerParameters.clone();
        return clone;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        RemoteFlashRunConfigurationForm remoteFlashRunConfigurationForm = new RemoteFlashRunConfigurationForm(this.getProject());
        if (remoteFlashRunConfigurationForm == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration", "getConfigurationEditor"));
        }
        return remoteFlashRunConfigurationForm;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunnerParameters = new RemoteFlashRunnerParameters();
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration", "getState"));
        }
        try {
            this.myRunnerParameters.checkAndGetModuleAndBC(this.getProject());
        }
        catch (RuntimeConfigurationError e) {
            throw new ExecutionException(e.getMessage());
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        this.myRunnerParameters.checkAndGetModuleAndBC(this.getProject());
    }

    @NotNull
    public RemoteFlashRunnerParameters getRunnerParameters() {
        RemoteFlashRunnerParameters remoteFlashRunnerParameters = this.myRunnerParameters;
        if (remoteFlashRunnerParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration", "getRunnerParameters"));
        }
        return remoteFlashRunnerParameters;
    }

    @NotNull
    public Module[] getModules() {
        Module module = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myRunnerParameters.getModuleName());
        if (module != null && ModuleType.get((Module)module) instanceof FlexModuleType) {
            Module[] moduleArray = new Module[]{module};
            if (moduleArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration", "getModules"));
            }
            return moduleArray;
        }
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/RemoteFlashRunConfiguration", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    public String suggestedName() {
        String bcName = this.myRunnerParameters.getBCName();
        return StringUtil.isEmptyOrSpaces((String)bcName) ? DEFAULT_NAME : "Remote debug (" + bcName + ")";
    }
}

