/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderSdkFinder;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import icons.FlexIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexSdkType2
extends SdkType {
    public static final String NAME = "Flex SDK Type (new)";
    public static final String LAST_SELECTED_FLEX_SDK_HOME_KEY = "last.selected.flex.sdk.home";

    public FlexSdkType2() {
        super(NAME);
    }

    @Nullable
    public String suggestHomePath() {
        String path = PropertiesComponent.getInstance().getValue(LAST_SELECTED_FLEX_SDK_HOME_KEY);
        if (path != null) {
            return PathUtil.getParentPath((String)path);
        }
        String fbInstallation = FlashBuilderSdkFinder.findFBInstallationPath();
        return fbInstallation == null ? null : fbInstallation + "/" + "sdks";
    }

    public boolean isValidSdkHome(String path) {
        if (path == null) {
            return false;
        }
        VirtualFile sdkHome = LocalFileSystem.getInstance().findFileByPath(path);
        if (sdkHome == null || !sdkHome.isDirectory()) {
            return false;
        }
        return FlexSdkUtils.doReadFlexSdkVersion(sdkHome) != null || FlexSdkUtils.doReadAirSdkVersion(sdkHome) != null;
    }

    public String suggestSdkName(String currentSdkName, String sdkHome) {
        return PathUtil.getFileName((String)sdkHome);
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "createAdditionalDataConfigurable"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "createAdditionalDataConfigurable"));
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "saveAdditionalData"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "saveAdditionalData"));
        }
    }

    @NotNull
    public String getPresentableName() {
        String string = FlexBundle.message("flex.sdk.presentable.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "getPresentableName"));
        }
        return string;
    }

    @NotNull
    public Icon getIconForAddAction() {
        Icon icon = this.getIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "getIconForAddAction"));
        }
        return icon;
    }

    @NotNull
    public static FlexSdkType2 getInstance() {
        FlexSdkType2 flexSdkType2 = (FlexSdkType2)SdkType.findInstance(FlexSdkType2.class);
        if (flexSdkType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "getInstance"));
        }
        return flexSdkType2;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "setupSdkPaths"));
        }
        SdkModificator modificator = sdk.getSdkModificator();
        this.setupSdkPaths(sdk.getHomeDirectory(), modificator);
        modificator.commitChanges();
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = FlexIcons.Flex.Sdk.Flex_sdk;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getHelpTopic() {
        if ("reference.project.structure.sdk.flex" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "getHelpTopic"));
        }
        return "reference.project.structure.sdk.flex";
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "isRootTypeApplicable"));
        }
        return type == OrderRootType.CLASSES || type == OrderRootType.SOURCES || type == JavadocOrderRootType.getInstance();
    }

    public String getDefaultDocumentationUrl(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "getDefaultDocumentationUrl"));
        }
        return "http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/";
    }

    public String getVersionString(String sdkHome) {
        VirtualFile sdkRoot = LocalFileSystem.getInstance().findFileByPath(sdkHome);
        String flexVersion = FlexSdkUtils.doReadFlexSdkVersion(sdkRoot);
        if (flexVersion != null) {
            return flexVersion;
        }
        String airVersion = FlexSdkUtils.doReadAirSdkVersion(sdkRoot);
        return airVersion != null ? "AIR SDK " + airVersion : FlexBundle.message("flex.sdk.version.unknown", new Object[0]);
    }

    private void setupSdkPaths(VirtualFile sdkRoot, SdkModificator sdkModificator) {
        VirtualFile projectsDir;
        VirtualFile baseDir;
        if (sdkRoot == null || !sdkRoot.isValid()) {
            return;
        }
        PropertiesComponent.getInstance().setValue(LAST_SELECTED_FLEX_SDK_HOME_KEY, sdkRoot.getPath());
        sdkRoot.refresh(false, true);
        sdkModificator.setVersionString(this.getVersionString(sdkRoot.getPath()));
        VirtualFile playerDir = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)((NullableComputable)() -> {
            VirtualFile libsDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(sdkRoot.getPath() + "/frameworks/libs");
            if (libsDir != null && libsDir.isDirectory()) {
                libsDir.refresh(false, true);
                return libsDir.findChild("player");
            }
            return null;
        }));
        if (playerDir != null) {
            FlexSdkUtils.processPlayerglobalSwcFiles(playerDir, (Processor<VirtualFile>)((Processor)playerglobalSwcFile -> {
                FlexSdkType2.addSwcRoot(sdkModificator, playerglobalSwcFile);
                return true;
            }));
        }
        if ((baseDir = sdkRoot.findChild("frameworks")) != null && baseDir.isDirectory()) {
            FlexSdkType2.addSwcRoots(sdkModificator, baseDir, Collections.singletonList("libs/air/airglobal.swc"), false);
            FlexSdkType2.addFlexSdkSwcRoots(sdkModificator, baseDir);
        }
        if ((projectsDir = VfsUtil.findRelativeFile((String)"frameworks/projects", (VirtualFile)sdkRoot)) != null && projectsDir.isDirectory()) {
            FlexSdkType2.findSourceRoots(projectsDir, sdkModificator);
        }
    }

    public static void addFlexSdkSwcRoots(SdkModificator sdkModificator, VirtualFile frameworksDir) {
        FlexSdkType2.addSwcRoots(sdkModificator, frameworksDir, Arrays.asList("libs", "libs/mx", "libs/air", "libs/mobile", "themes/Mobile"), true);
    }

    private static void findSourceRoots(VirtualFile dir, final SdkModificator sdkModificator) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT}){

            public boolean visitFile(@NotNull VirtualFile child) {
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2$1", "visitFile"));
                }
                if (child.isDirectory() && child.getName().equals("src")) {
                    sdkModificator.addRoot(child, OrderRootType.SOURCES);
                    return false;
                }
                return true;
            }
        });
    }

    private static void addSwcRoots(SdkModificator sdkModificator, VirtualFile baseDir, List<String> libRelativePaths, boolean skipAirglobalSwc) {
        for (String libRelativePath : libRelativePaths) {
            VirtualFile libFileOrDir = baseDir.findFileByRelativePath(libRelativePath);
            if (libFileOrDir == null) continue;
            if (libFileOrDir.isDirectory()) {
                for (VirtualFile libCandidate : libFileOrDir.getChildren()) {
                    if (libCandidate.isDirectory() || !"swc".equalsIgnoreCase(libCandidate.getExtension()) || skipAirglobalSwc && libCandidate.getPath().endsWith("frameworks/libs/air/airglobal.swc")) continue;
                    FlexSdkType2.addSwcRoot(sdkModificator, libCandidate);
                }
                continue;
            }
            if (!"swc".equalsIgnoreCase(libFileOrDir.getExtension()) || skipAirglobalSwc && libFileOrDir.getPath().endsWith("frameworks/libs/air/airglobal.swc")) continue;
            FlexSdkType2.addSwcRoot(sdkModificator, libFileOrDir);
        }
    }

    private static void addSwcRoot(@NotNull SdkModificator sdkModificator, @NotNull VirtualFile swcFile) {
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "addSwcRoot"));
        }
        if (swcFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "swcFile", "com/intellij/lang/javascript/flex/sdk/FlexSdkType2", "addSwcRoot"));
        }
        VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(swcFile);
        if (jarRoot != null) {
            sdkModificator.addRoot(jarRoot, OrderRootType.CLASSES);
        }
    }
}

