/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.validation.JSFunctionCollector;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ActionScriptImplementedMethodProcessor
extends JSCollectMembersToImplementProcessor {
    @NotNull
    protected final JSClass myJsClass;

    public static Collection<JSFunction> collectFunctionsToImplement(@NotNull JSClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/validation/ActionScriptImplementedMethodProcessor", "collectFunctionsToImplement"));
        }
        final JSFunctionCollector alreadyUsedMethods = new JSFunctionCollector();
        ActionScriptImplementedMethodProcessor processor = new ActionScriptImplementedMethodProcessor(clazz){

            @Override
            protected void addNonImplementedFunction(JSFunction function) {
                if (alreadyUsedMethods.hasFunctionWithTheSameKind(function.getName(), function.getKind())) {
                    return;
                }
                alreadyUsedMethods.add(function);
            }
        };
        JSResolveUtil.processInterfaceMembers((JSClass)clazz, (JSCollectMembersToImplementProcessor)processor);
        return alreadyUsedMethods.getFunctions();
    }

    public ActionScriptImplementedMethodProcessor(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/validation/ActionScriptImplementedMethodProcessor", "<init>"));
        }
        super(null, false);
        this.myJsClass = jsClass;
    }

    @NotNull
    protected ResultSink createResultSink() {
        CompletionResultSink completionResultSink = new CompletionResultSink(this.place);
        if (completionResultSink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/ActionScriptImplementedMethodProcessor", "createResultSink"));
        }
        return completionResultSink;
    }

    protected void processMembers(@NotNull List<PsiElement> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/lang/javascript/validation/ActionScriptImplementedMethodProcessor", "processMembers"));
        }
        JSFunctionCollector functionsCollector = null;
        for (PsiElement _function : results) {
            JSFunction o;
            JSFunction function;
            String name;
            if (!(_function instanceof JSFunction) || (name = (function = (JSFunction)_function).getName()) == null) continue;
            if (functionsCollector == null) {
                functionsCollector = this.collectVisibleFunctions();
            }
            if ((o = functionsCollector.findFunctionWithTheSameKind(name, function.getKind())) == null) {
                JSVariable var;
                if (JSPsiImplUtils.isGetterOrSetter((JSFunction)function) && (var = (JSVariable)JSInheritanceUtil.findMember((String)name, (JSClass)this.myJsClass, (JSInheritanceUtil.SearchedMemberType)JSInheritanceUtil.SearchedMemberType.Fields, null, (boolean)true)) != null && ActionScriptResolveUtil.fieldIsImplicitAccessorMethod((JSFunction)function, (JSVariable)var)) continue;
                this.addNonImplementedFunction(function);
                continue;
            }
            this.addImplementedFunction(function, o);
        }
    }

    @NotNull
    private JSFunctionCollector collectVisibleFunctions() {
        JSFunctionCollector jSFunctionCollector = JSFunctionCollector.collectAllVisibleClassFunctions((JSClass)this.myJsClass, null, jsFunction -> {
            JSAttributeList attributeList = jsFunction.getAttributeList();
            if (!JSInheritanceUtil.canHaveSuperMember((JSAttributeList)attributeList)) {
                return false;
            }
            PsiElement parentClass = JSResolveUtil.findParent((PsiElement)jsFunction);
            return attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC || this.myJsClass == parentClass;
        });
        if (jSFunctionCollector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/ActionScriptImplementedMethodProcessor", "collectVisibleFunctions"));
        }
        return jSFunctionCollector;
    }

    protected void addImplementedFunction(JSFunction interfaceFunction, JSFunction implementationFunction) {
    }

    protected abstract void addNonImplementedFunction(JSFunction var1);
}

