/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.refactoring.surround.CoffeeScriptBaseSurrounder;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptWithTryCatchSurrounder
extends CoffeeScriptBaseSurrounder {
    @Override
    protected String getStatementTemplate(PsiElement context) {
        context.getParent();
        return "try\n  body\ncatch error\n  error_handling_code";
    }

    @Override
    @NotNull
    protected ASTNode getNodeToReplace(ASTNode surroundedNode) {
        JSTryStatement tryStatement = (JSTryStatement)surroundedNode.getPsi();
        ASTNode aSTNode = tryStatement.getStatement().getChildren()[0].getNode();
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/refactoring/surround/CoffeeScriptWithTryCatchSurrounder", "getNodeToReplace"));
        }
        return aSTNode;
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSTryStatement tryStatement = (JSTryStatement)statementNode.getPsi();
        ASTNode errorNode = tryStatement.getAllCatchBlocks()[0].getStatement().getNode();
        int startOffset = errorNode.getStartOffset();
        int endOffset = startOffset + errorNode.getTextLength();
        return new TextRange(startOffset, endOffset);
    }

    public String getTemplateDescription() {
        return CsBundle.message("surrounder.try.catch", new Object[0]);
    }

    public boolean isApplicable(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/coffeescript/refactoring/surround/CoffeeScriptWithTryCatchSurrounder", "isApplicable"));
        }
        return true;
    }
}

