/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliDialog;
import com.intellij.database.cli.dump.DumpConfigurationsHolder;
import com.intellij.database.cli.restore.RestoreConfigurationsHolder;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseCliAction
extends DumbAwareAction {
    public void update(AnActionEvent e) {
        boolean enabled = this.isEnabled(e);
        e.getPresentation().setEnabledAndVisible(enabled);
        if (!enabled) {
            return;
        }
        DbDataSource dataSource = (DbDataSource)ObjectUtils.notNull((Object)DatabaseCliAction.getDataSource(e));
        DatabaseFamilyId family = DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource.getDelegate());
        List selected = DatabaseCliAction.getSelectedElements(e.getProject()).toList();
        CliConfigurationPack configurations = ((CliConfigurationPack)ObjectUtils.notNull((Object)this.getConfigurations(family))).filtered(selected);
        e.getPresentation().setText(this.getText(configurations, (DatabaseSystem)dataSource, true));
    }

    @NotNull
    protected abstract String getMask();

    @NotNull
    protected abstract String getCommonText(boolean var1);

    @Nullable
    public abstract CliConfigurationPack getConfigurations(@NotNull DatabaseFamilyId var1);

    public void actionPerformed(AnActionEvent e) {
        DbDataSource dataSource = (DbDataSource)ObjectUtils.notNull((Object)DatabaseCliAction.getDataSource(e));
        DatabaseFamilyId id = DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource.getDelegate());
        CliConfigurationPack configurations = (CliConfigurationPack)ObjectUtils.notNull((Object)this.getConfigurations(id));
        List selected = DatabaseCliAction.getSelectedElements(e.getProject()).toList();
        Project project = (Project)ObjectUtils.notNull((Object)e.getProject());
        String dialogTitle = this.getText(configurations, (DatabaseSystem)dataSource, false);
        CliDialog dialog = new CliDialog(dataSource, project, selected, configurations, dialogTitle);
        dialog.show();
    }

    @NotNull
    private String getText(@NotNull CliConfigurationPack configurations, @NotNull DatabaseSystem system, boolean action) {
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/database/actions/DatabaseCliAction", "getText"));
        }
        if (system == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/actions/DatabaseCliAction", "getText"));
        }
        String string = (configurations.isSingleConfiguration() ? this.getOneConfigurationText(configurations, action) : this.getCommonText(action)) + (action ? "" : String.format(" (%s)", system.getName()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction", "getText"));
        }
        return string;
    }

    @NotNull
    private String getOneConfigurationText(@NotNull CliConfigurationPack configurations, boolean action) {
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/database/actions/DatabaseCliAction", "getOneConfigurationText"));
        }
        String name = configurations.first().getName();
        String string = String.format(this.getMask(), action ? "'" + StringUtil.escapeMnemonics((String)name) + "'" : name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction", "getOneConfigurationText"));
        }
        return string;
    }

    @NotNull
    private static JBIterable<DbElement> getSelectedElements(@Nullable Project project) {
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction", "getSelectedElements"));
            }
            return jBIterable;
        }
        DatabaseView view2 = DatabaseView.getDatabaseView(project);
        if (view2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction", "getSelectedElements"));
            }
            return jBIterable;
        }
        JBIterable<Object> elements = view2.getSelectedElements();
        JBIterable jBIterable = view2.getSelectedElements().filter(DatabaseStructure.GroupElement.class).filter(element -> element.getParent() instanceof DbNamespaceImpl).flatMap(DatabaseCliAction::expandGroupElement).append((Iterable)JBIterable.from(elements).filter(DbElement.class)).unique();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction", "getSelectedElements"));
        }
        return jBIterable;
    }

    @NotNull
    private static Iterable<DbElement> expandGroupElement(@NotNull DatabaseStructure.GroupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/DatabaseCliAction", "expandGroupElement"));
        }
        DbElement parent = (DbElement)element.getParent();
        ObjectKind kind = element.getChildKind();
        JBIterable jBIterable = DbImplUtil.isDataTable(kind) ? parent.getDbChildren(DbElement.class, kind) : JBIterable.of((Object)parent);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction", "expandGroupElement"));
        }
        return jBIterable;
    }

    private boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseCliAction", "isEnabled"));
        }
        DbDataSource dataSource = DatabaseCliAction.getDataSource(e);
        if (dataSource == null) {
            return false;
        }
        LocalDataSource delegate = (LocalDataSource)dataSource.getDelegate();
        if (!DatabaseCliAction.isHostAndPortExists(delegate)) {
            return false;
        }
        CliConfigurationPack configurations = this.getConfigurations(DatabaseFamilyId.forDataSource((DatabaseSystem)dataSource));
        return configurations != null && !configurations.filtered(DatabaseCliAction.getSelectedElements(e.getProject()).toList()).isEmpty() && e.getProject() != null;
    }

    private static boolean isHostAndPortExists(@NotNull LocalDataSource source) {
        String url;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/actions/DatabaseCliAction", "isHostAndPortExists"));
        }
        DatabaseDriver driver = source.getDatabaseDriver();
        RawConnectionConfig config = source.getConnectionConfig();
        String string = url = config == null ? null : config.getUrl();
        if (url == null || driver == null) {
            return false;
        }
        List<StatelessJdbcUrlParser> parsers = driver.getJDBCUrlParsers();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(parsers, url, (Ref<JdbcUrlParser>)Ref.create());
        return hostPort != null && hostPort.first != null && hostPort.second != null;
    }

    @Nullable
    private static DbDataSource getDataSource(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/DatabaseCliAction", "getDataSource"));
        }
        Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        HashSet sources = ContainerUtil.newHashSet();
        elements.forEach(element -> sources.add(element.getDataSource()));
        DbDataSource first = (DbDataSource)ContainerUtil.getFirstItem((Collection)sources);
        return sources.size() == 1 && first != null && DbImplUtil.canConnectTo((DbElement)first) ? first : null;
    }

    public static class Restore
    extends DatabaseCliAction {
        @Override
        @Nullable
        public CliConfigurationPack getConfigurations(@NotNull DatabaseFamilyId family) {
            if (family == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/database/actions/DatabaseCliAction$Restore", "getConfigurations"));
            }
            return RestoreConfigurationsHolder.of(family);
        }

        @Override
        @NotNull
        protected String getMask() {
            if ("Restore with %s" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction$Restore", "getMask"));
            }
            return "Restore with %s";
        }

        @Override
        @NotNull
        protected String getCommonText(boolean action) {
            String string = "Restore" + (action ? "..." : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction$Restore", "getCommonText"));
            }
            return string;
        }
    }

    public static class Dump
    extends DatabaseCliAction {
        @Override
        @Nullable
        public CliConfigurationPack getConfigurations(@NotNull DatabaseFamilyId family) {
            if (family == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/database/actions/DatabaseCliAction$Dump", "getConfigurations"));
            }
            return DumpConfigurationsHolder.of(family);
        }

        @Override
        @NotNull
        protected String getMask() {
            if ("Dump with %s" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction$Dump", "getMask"));
            }
            return "Dump with %s";
        }

        @Override
        @NotNull
        protected String getCommonText(boolean action) {
            String string = "Dump" + (action ? "..." : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/DatabaseCliAction$Dump", "getCommonText"));
            }
            return string;
        }
    }
}

