/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.BasicElementAction;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.postgres.PostgresDatabase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.MultiMap;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0002H\u0014J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0010H\u0014J\u001c\u0010\u0012\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0010H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/actions/HideSchemasAction;", "Lcom/intellij/database/actions/BasicElementAction;", "Lcom/intellij/database/model/basic/BasicNamespace;", "()V", "cast", "node", "Lcom/intellij/database/model/basic/BasicNode;", "check", "", "doIt", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "selection", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/database/model/basic/BasicModel;", "enabled", "database-impl"})
public final class HideSchemasAction
extends BasicElementAction<BasicNamespace> {
    @Override
    @Nullable
    protected BasicNamespace cast(@Nullable BasicNode node) {
        BasicNode basicNode = node;
        if (!(basicNode instanceof BasicNamespace)) {
            basicNode = null;
        }
        return (BasicNamespace)basicNode;
    }

    @Override
    protected boolean check(@NotNull BasicNamespace node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return node.isVisible();
    }

    @Override
    protected boolean enabled(@NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkParameterIsNotNull(selection, (String)"selection");
        for (BasicNamespace element : selection.values()) {
            if (!(element instanceof PostgresDatabase) || !((PostgresDatabase)element).isCurrent()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doIt(@NotNull AnActionEvent e, @NotNull Project project, @NotNull MultiMap<BasicModel, BasicNamespace> selection) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(selection, (String)"selection");
        for (LocalDataSource localDataSource : DataSourceManagerEx.getInstanceEx(project).getDataSources()) {
            DasModel model = localDataSource.getModel();
            if (!(model instanceof BasicModel) || !selection.containsKey((Object)model)) continue;
            DataSourceUiUtil.setNamespacesVisible(project, localDataSource, selection.get((Object)model), false);
            DataSourceSyncManager.getInstance().stopSynchronization(localDataSource).whenCompleteAsync(new BiConsumer<DataSourceSyncManager.SyncResult, Throwable>(localDataSource){
                final /* synthetic */ LocalDataSource $dataSource;

                public final void accept(DataSourceSyncManager.SyncResult r, Throwable th) {
                    DatabaseModelLoader.updateModelVisibility(this.$dataSource.getModel(), this.$dataSource.getIntrospectionScope());
                }
                {
                    this.$dataSource = localDataSource;
                }
            }, AsyncUtil.POOL_EXECUTOR);
        }
    }
}

