/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliProperties;
import com.intellij.database.cli.CliRunner;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliDialog
extends DialogWrapper {
    private static final String DIMENSION_KEY = "DUMP_DIALOG_DIMENSION_KEY";
    private static final Dimension MIN_SIZE = JBUI.size((int)300, (int)100);
    private static final Dimension PREFERRED_SIZE = JBUI.size((int)600, (int)300);
    private final DbDataSource mySource;
    private final Project myProject;
    private final CliConfigurationPack myPack;
    private final MyPanel myPanel;

    public CliDialog(@NotNull DbDataSource source, @NotNull Project project, @NotNull Collection<DbElement> elements, @NotNull CliConfigurationPack configurations, @NotNull String title) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/cli/CliDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/CliDialog", "<init>"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliDialog", "<init>"));
        }
        if (configurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/database/cli/CliDialog", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/cli/CliDialog", "<init>"));
        }
        super(project);
        this.mySource = source;
        this.myProject = project;
        this.myPack = configurations;
        CliConfigurationPack filtered = configurations.filtered(elements);
        this.myPanel = filtered.isSingleConfiguration() ? new MySingleConfigurationPanel(project, elements, filtered) : new MyMultiConfigurationPanel(project, elements, filtered);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPanel);
        this.setTitle(title);
        this.initValidation();
        this.init();
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.putValue("Name", "Run");
    }

    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        CliProperties.storeLastUsedConfiguration(this.myPack, this.myPanel.configuration());
        CliModel model = this.myPanel.model();
        String executable = model.getExecutableCommand();
        List<String> parameterizable = model.getParameterizable();
        model.store();
        super.doOKAction();
        new CliRunner(this.mySource, this.myProject, this.myPanel.configuration(), parameterizable, executable).run();
    }

    protected boolean shouldAddErrorNearButtons() {
        return !CliDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.model().getPreferredFocusableComponent();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myPanel.validator().createInfo(this.myPanel.model());
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent component = this.myPanel.component();
        component.setMinimumSize(MIN_SIZE);
        component.setPreferredSize(PREFERRED_SIZE);
        return component;
    }

    private static class MySingleConfigurationPanel
    extends JPanel
    implements MyPanel {
        private final CliModel myModel;
        private final CliConfiguration myConfiguration;
        private final CliDialogValidator myValidator;

        MySingleConfigurationPanel(@NotNull Project project, @NotNull Collection<DbElement> elements, @NotNull CliConfigurationPack configurations) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel", "<init>"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel", "<init>"));
            }
            if (configurations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel", "<init>"));
            }
            super(new BorderLayout());
            CliConfiguration first = configurations.first();
            this.myConfiguration = (CliConfiguration)ObjectUtils.notNull((Object)first);
            this.myModel = new CliModel(project, this.myConfiguration.getObjectsPreparer().prepare(elements).get(), this.myConfiguration);
            this.myValidator = this.myConfiguration.getValidator();
            Disposer.register((Disposable)this, (Disposable)this.myModel);
            Disposer.register((Disposable)this.myModel, (Disposable)this.myValidator);
            this.add(this.myModel.getComponent());
        }

        @Override
        @NotNull
        public CliDialogValidator validator() {
            CliDialogValidator cliDialogValidator = this.myValidator;
            if (cliDialogValidator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel", "validator"));
            }
            return cliDialogValidator;
        }

        @Override
        @NotNull
        public CliConfiguration configuration() {
            CliConfiguration cliConfiguration = this.myConfiguration;
            if (cliConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel", "configuration"));
            }
            return cliConfiguration;
        }

        @Override
        @NotNull
        public CliModel model() {
            CliModel cliModel = this.myModel;
            if (cliModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel", "model"));
            }
            return cliModel;
        }

        @Override
        @NotNull
        public JComponent component() {
            MySingleConfigurationPanel mySingleConfigurationPanel = this;
            if (mySingleConfigurationPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MySingleConfigurationPanel", "component"));
            }
            return mySingleConfigurationPanel;
        }

        public void dispose() {
        }
    }

    private static class MyMultiConfigurationPanel
    extends JPanel
    implements MyPanel {
        private final CardLayout myLayout;
        private final Map<CliConfiguration, Data> myMap;
        private final JPanel myCardPanel;
        private final ActionToolbar myToolbar;
        private CliConfiguration mySelectedConfiguration;

        MyMultiConfigurationPanel(@NotNull Project project, @NotNull Collection<DbElement> elements, @NotNull CliConfigurationPack configurations) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "<init>"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "<init>"));
            }
            if (configurations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "<init>"));
            }
            super(new BorderLayout());
            this.myLayout = new CardLayout();
            this.myMap = ContainerUtil.newHashMap();
            this.myCardPanel = new JPanel(this.myLayout);
            configurations.getConfigurations().forEach(c -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "lambda$new$0"));
                }
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "lambda$new$0"));
                }
                CliDialogValidator validator = c.getValidator();
                CliModel model = new CliModel(project, c.getObjectsPreparer().prepare(elements).get(), (CliConfiguration)c);
                Disposer.register((Disposable)this, (Disposable)model);
                Disposer.register((Disposable)model, (Disposable)validator);
                this.myMap.put((CliConfiguration)c, new Data(validator, model));
                this.myCardPanel.add((Component)model.getComponent(), c.getName());
            });
            ArrayList actions = ContainerUtil.newArrayList();
            boolean first = true;
            for (CliConfiguration configuration : configurations.getConfigurations()) {
                if (!first) {
                    actions.add(new Separator());
                }
                first = false;
                actions.add(new MyToggle(configuration));
            }
            this.myToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)new DefaultActionGroup((List)actions), true);
            this.add((Component)this.myToolbar.getComponent(), "North");
            this.add((Component)this.myCardPanel, "Center");
            this.mySelectedConfiguration = (CliConfiguration)ObjectUtils.notNull((Object)CliProperties.getLastUsedConfigurationKey(configurations), (Object)configurations.first());
            this.myLayout.show(this.myCardPanel, ((CliConfiguration)ObjectUtils.notNull((Object)this.mySelectedConfiguration)).getName());
        }

        @Override
        @NotNull
        public CliConfiguration configuration() {
            CliConfiguration cliConfiguration = this.mySelectedConfiguration;
            if (cliConfiguration == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "configuration"));
            }
            return cliConfiguration;
        }

        @Override
        @NotNull
        public CliDialogValidator validator() {
            CliDialogValidator cliDialogValidator = this.myMap.get((Object)this.mySelectedConfiguration).validator;
            if (cliDialogValidator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "validator"));
            }
            return cliDialogValidator;
        }

        @Override
        @NotNull
        public CliModel model() {
            CliModel cliModel = this.myMap.get((Object)this.mySelectedConfiguration).model;
            if (cliModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "model"));
            }
            return cliModel;
        }

        @Override
        @NotNull
        public JComponent component() {
            MyMultiConfigurationPanel myMultiConfigurationPanel = this;
            if (myMultiConfigurationPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel", "component"));
            }
            return myMultiConfigurationPanel;
        }

        public void dispose() {
        }

        private class MyToggle
        extends ToggleAction
        implements DumbAware {
            private final CliConfiguration myConfiguration;

            private MyToggle(CliConfiguration configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$MyToggle", "<init>"));
                }
                super(StringUtil.escapeMnemonics((String)configuration.getName()));
                this.myConfiguration = configuration;
                this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
                this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$MyToggle", "update"));
                }
                e.getPresentation().setEnabledAndVisible(true);
                super.update(e);
            }

            public boolean isSelected(AnActionEvent e) {
                return MyMultiConfigurationPanel.this.mySelectedConfiguration == this.myConfiguration;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                if (!state) {
                    return;
                }
                boolean expanded = ((Data)((MyMultiConfigurationPanel)MyMultiConfigurationPanel.this).myMap.get((Object)((MyMultiConfigurationPanel)MyMultiConfigurationPanel.this).mySelectedConfiguration)).model.isExpanded();
                MyMultiConfigurationPanel.this.mySelectedConfiguration = this.myConfiguration;
                MyMultiConfigurationPanel.this.myToolbar.updateActionsImmediately();
                ((Data)((MyMultiConfigurationPanel)MyMultiConfigurationPanel.this).myMap.get((Object)((MyMultiConfigurationPanel)MyMultiConfigurationPanel.this).mySelectedConfiguration)).model.setExpanded(expanded);
                MyMultiConfigurationPanel.this.myLayout.show(MyMultiConfigurationPanel.this.myCardPanel, MyMultiConfigurationPanel.this.mySelectedConfiguration.getName());
            }

            public boolean displayTextInToolbar() {
                return true;
            }
        }

        private static class Data {
            final CliDialogValidator validator;
            final CliModel model;

            private Data(@NotNull CliDialogValidator validator, @NotNull CliModel model) {
                if (validator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$Data", "<init>"));
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/cli/CliDialog$MyMultiConfigurationPanel$Data", "<init>"));
                }
                this.validator = validator;
                this.model = model;
            }
        }
    }

    private static interface MyPanel
    extends Disposable {
        @NotNull
        public CliDialogValidator validator();

        @NotNull
        public CliConfiguration configuration();

        @NotNull
        public CliModel model();

        @NotNull
        public JComponent component();
    }
}

