/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CliLexeme
implements Comparable<CliLexeme> {
    private final IElementType myType;
    private final int myStart;
    private final int myEnd;
    private final String myText;

    public CliLexeme(@NotNull String text, @NotNull IElementType type, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/CliLexeme", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/cli/CliLexeme", "<init>"));
        }
        this.myType = type;
        this.myStart = start;
        this.myEnd = end;
        this.myText = text;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliLexeme", "getText"));
        }
        return string;
    }

    @NotNull
    public IElementType getType() {
        IElementType iElementType = this.myType;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliLexeme", "getType"));
        }
        return iElementType;
    }

    @NotNull
    public CliLexeme convertLineWrapToWhitespace() {
        CliLexeme cliLexeme = this.isLineWrap() ? new CliLexeme(" ", DbCliTokenType.BAD, this.myStart, this.myEnd) : this;
        if (cliLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliLexeme", "convertLineWrapToWhitespace"));
        }
        return cliLexeme;
    }

    public boolean isArgument() {
        return this.myType == DbCliTokenType.LONG_PARAMETER || this.myType == DbCliTokenType.SHORT_PARAMETER;
    }

    public boolean isBad() {
        return this.myType == DbCliTokenType.BAD;
    }

    public boolean isParameter() {
        return this.myType == DbCliTokenType.VALUE;
    }

    public boolean isWhitespaceOrBad() {
        return this.isBad() && this.isWhitespace();
    }

    public boolean isWhitespace() {
        return StringUtil.equals((CharSequence)this.myText, (CharSequence)" ");
    }

    private boolean isLineWrap() {
        return this.isBad() && StringUtil.equals((CharSequence)this.myText, (CharSequence)"\n");
    }

    @Override
    public int compareTo(CliLexeme o) {
        return Integer.compare(this.myStart, o.myStart);
    }

    public int hashCode() {
        return this.myStart + this.myEnd * 31 + this.myText.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CliLexeme)) {
            return false;
        }
        CliLexeme lexeme = (CliLexeme)obj;
        return lexeme.myStart == this.myStart && lexeme.myEnd == this.myEnd && StringUtil.equals((CharSequence)lexeme.myText, (CharSequence)this.myText);
    }

    public String toString() {
        return this.myText + " [" + this.myType + "]";
    }
}

