/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.lexer.DbCliLexerAdapter;
import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCliUtil {
    public static final String[] INPUT = new String[]{"<"};

    private DbCliUtil() {
    }

    @NotNull
    public static String cutParameter(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "cutParameter"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/DbCliUtil", "cutParameter"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/DbCliUtil", "cutParameter"));
        }
        String string = StringUtil.trim((String)text.substring(current.getEnd(), next.getStart()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "cutParameter"));
        }
        return string;
    }

    @NotNull
    public static List<CliLexeme> filteredLexemes(@NotNull String text, @NotNull List<String> parameterizable) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "filteredLexemes"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/DbCliUtil", "filteredLexemes"));
        }
        List<CliLexeme> list = DbCliUtil.filterLexemes(DbCliUtil.rawLexemes(text), parameterizable);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "filteredLexemes"));
        }
        return list;
    }

    @NotNull
    public static List<Pair<CliLexeme, CliLexeme>> lexemePairs(@NotNull CliContextDescriptor state, @NotNull List<CliLexeme> lexemes, @NotNull String text, @NotNull CliComponent component) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/cli/DbCliUtil", "lexemePairs"));
        }
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/DbCliUtil", "lexemePairs"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "lexemePairs"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/cli/DbCliUtil", "lexemePairs"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            CliLexeme next;
            CliLexeme current = lexemes.get(i2);
            CliLexeme cliLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbCliUtil.getLastCharacterLexeme(text);
            if (!component.isMyLexeme(text, current, next, state)) continue;
            result2.add(Pair.create((Object)current, (Object)next));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "lexemePairs"));
        }
        return arrayList;
    }

    @NotNull
    public static String clearString(@NotNull String s, @NotNull Function<String, String> unquoter) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/cli/DbCliUtil", "clearString"));
        }
        if (unquoter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquoter", "com/intellij/database/cli/DbCliUtil", "clearString"));
        }
        String string = DbCliUtil.unescapeAll(unquoter.apply(s));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "clearString"));
        }
        return string;
    }

    @NotNull
    public static List<String> getCommandLineArguments(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull String command, @NotNull List<String> parameterizable) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/DbCliUtil", "getCommandLineArguments"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/DbCliUtil", "getCommandLineArguments"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/DbCliUtil", "getCommandLineArguments"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        List<CliLexeme> lexemes = DbCliUtil.filteredLexemes(command, parameterizable);
        for (int i2 = 0; i2 < lexemes.size(); ++i2) {
            CliLexeme next;
            CliLexeme current = lexemes.get(i2);
            CliLexeme cliLexeme = next = i2 < lexemes.size() - 1 ? lexemes.get(i2 + 1) : DbCliUtil.getLastCharacterLexeme(command);
            if (current.isBad()) continue;
            result2.add(DbCliUtil.getArgument(command, current, next, processor, parameterizable));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getCommandLineArguments"));
        }
        return arrayList;
    }

    @NotNull
    public static Condition<? super CliLexeme> lexemeFinder(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "lexemeFinder"));
        }
        Condition condition = lexeme -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "lambda$lexemeFinder$0"));
            }
            return StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)text);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "lexemeFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<CliArgument> argumentFinder(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "argumentFinder"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/DbCliUtil", "argumentFinder"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/DbCliUtil", "argumentFinder"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/DbCliUtil", "argumentFinder"));
        }
        Condition condition = argument -> {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "lambda$argumentFinder$1"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/DbCliUtil", "lambda$argumentFinder$1"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/DbCliUtil", "lambda$argumentFinder$1"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/DbCliUtil", "lambda$argumentFinder$1"));
            }
            return argument.isMyLexeme(text, current, next, cd);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "argumentFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<? super CliLexeme> argumentWithParameterFinder(@NotNull List<CliLexeme> rawLexemes, @NotNull LexemeIndicators indicators) {
        if (rawLexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawLexemes", "com/intellij/database/cli/DbCliUtil", "argumentWithParameterFinder"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/cli/DbCliUtil", "argumentWithParameterFinder"));
        }
        Condition condition = lexeme -> {
            if (indicators == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/cli/DbCliUtil", "lambda$argumentWithParameterFinder$2"));
            }
            if (rawLexemes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawLexemes", "com/intellij/database/cli/DbCliUtil", "lambda$argumentWithParameterFinder$2"));
            }
            return lexeme.isArgument() && ContainerUtil.find((Object[])indicators.getArgs(), DbCliUtil.stringFinder(lexeme)) != null && DbCliUtil.hasParameterAfterArgument(rawLexemes, lexeme, indicators);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "argumentWithParameterFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<? super CliLexeme> lexemeFinder(@NotNull String[] args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/DbCliUtil", "lexemeFinder"));
        }
        Condition condition = lexeme -> {
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/DbCliUtil", "lambda$lexemeFinder$3"));
            }
            return ContainerUtil.find((Object[])args, DbCliUtil.stringFinder(lexeme)) != null;
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "lexemeFinder"));
        }
        return condition;
    }

    @NotNull
    public static Condition<String> stringFinder(@NotNull CliLexeme lexeme) {
        if (lexeme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/cli/DbCliUtil", "stringFinder"));
        }
        Condition condition = s -> {
            if (lexeme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/cli/DbCliUtil", "lambda$stringFinder$4"));
            }
            return StringUtil.equals((CharSequence)lexeme.getText(), (CharSequence)s);
        };
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "stringFinder"));
        }
        return condition;
    }

    @NotNull
    public static List<String> fromElementsToSeparated(@NotNull Collection<DbElement> elements, @NotNull Condition<DbElement> condition) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DbCliUtil", "fromElementsToSeparated"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DbCliUtil", "fromElementsToSeparated"));
        }
        List list = ContainerUtil.map((Collection)ContainerUtil.filter(elements, condition), DasObject::getName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "fromElementsToSeparated"));
        }
        return list;
    }

    @NotNull
    public static List<String> getTablesNames(@NotNull Collection<DbElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DbCliUtil", "getTablesNames"));
        }
        List list = JBIterable.from(elements).filter(DasUtil.byClass(DbTable.class)).map(element -> (DbTable)element).map(DbCliUtil::getTableName).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getTablesNames"));
        }
        return list;
    }

    @NotNull
    public static String getCommandWithout(@NotNull String command, LexemeIndicators ... indicators) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/DbCliUtil", "getCommandWithout"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/cli/DbCliUtil", "getCommandWithout"));
        }
        List<CliLexeme> lexemes = DbCliUtil.rawLexemes(command);
        for (LexemeIndicators indicator : indicators) {
            if (indicator == null) continue;
            int lexemeIndex = DbCliUtil.getIndexFromCommand(lexemes, indicator);
            while (lexemeIndex != -1 && lexemeIndex != lexemes.size() - 1) {
                lexemes.remove(lexemeIndex);
                if (indicator.hasParameter()) {
                    while (lexemes.get(lexemeIndex).isWhitespace()) {
                        lexemes.remove(lexemeIndex);
                    }
                    lexemes.remove(lexemeIndex);
                }
                lexemeIndex = DbCliUtil.getIndexFromCommand(lexemes, indicator);
            }
        }
        String string = DbCliUtil.joinLexemes(lexemes);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getCommandWithout"));
        }
        return string;
    }

    @NotNull
    public static String joinLexemes(@NotNull List<CliLexeme> lexemes) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/DbCliUtil", "joinLexemes"));
        }
        String string = StringUtil.join(lexemes, CliLexeme::getText, (String)"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "joinLexemes"));
        }
        return string;
    }

    static int getIndexFromCommand(@NotNull List<CliLexeme> lexemes, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/DbCliUtil", "getIndexFromCommand"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/cli/DbCliUtil", "getIndexFromCommand"));
        }
        return ContainerUtil.lastIndexOf(lexemes, DbCliUtil.argumentWithParameterFinder(lexemes, indicators));
    }

    private static String getTableName(@NotNull DbTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/cli/DbCliUtil", "getTableName"));
        }
        DasObject parent = DasUtil.getParentOfKind((DasObject)table, (ObjectKind)ObjectKind.SCHEMA, (boolean)true);
        String parentName = parent == null ? "" : DbCliUtil.quote(parent.getName()) + ".";
        return parentName + DbCliUtil.quote(table.getName());
    }

    private static boolean hasParameterAfterArgument(@NotNull List<CliLexeme> lexemes, @NotNull CliLexeme lexeme, @NotNull LexemeIndicators indicators) {
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/DbCliUtil", "hasParameterAfterArgument"));
        }
        if (lexeme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/cli/DbCliUtil", "hasParameterAfterArgument"));
        }
        if (indicators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicators", "com/intellij/database/cli/DbCliUtil", "hasParameterAfterArgument"));
        }
        int index = ContainerUtil.indexOf(lexemes, (Object)lexeme);
        if (index == -1) {
            return false;
        }
        if (!indicators.hasParameter()) {
            return true;
        }
        return lexemes.size() - 1 > index && lexemes.get(index + 1).isParameter() || lexemes.size() - 2 > index && lexemes.get(index + 1).isWhitespace() && lexemes.get(index + 2).isParameter();
    }

    @NotNull
    public static List<CliLexeme> extractArguments(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "extractArguments"));
        }
        List<CliLexeme> list = DbCliUtil.getLexemes(text, DbCliUtil::index);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "extractArguments"));
        }
        return list;
    }

    @NotNull
    public static List<CliLexeme> rawLexemes(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "rawLexemes"));
        }
        List<CliLexeme> list = DbCliUtil.getLexemes(text, (lexemes, lexer) -> lexemes.add(DbCliUtil.lexeme(lexer)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "rawLexemes"));
        }
        return list;
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull CliComponent component, @NotNull CliContextDescriptor state) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        CliLexeme cliLexeme = DbCliUtil.createLexeme(component, state, false);
        if (cliLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        return cliLexeme;
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull CliComponent component, @NotNull CliContextDescriptor state, boolean spaceAfter) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        String result2 = " " + component.getFullArgument(state) + " ";
        CliLexeme cliLexeme = DbCliUtil.createLexeme(result2, spaceAfter);
        if (cliLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        return cliLexeme;
    }

    @NotNull
    public static CliLexeme createLexeme(@NotNull String result2, boolean spaceAfter) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        CliLexeme cliLexeme = new CliLexeme(spaceAfter ? StringUtil.trimLeading((String)result2) : StringUtil.trimTrailing((String)result2), DbCliTokenType.SYNTHETIC, -1, -1);
        if (cliLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "createLexeme"));
        }
        return cliLexeme;
    }

    @NotNull
    public static <T extends CliArgument> List<CliComponent> createComponents(@NotNull CliArgumentGroup<T> group2, @NotNull Function<T, CliComponent> constructor) {
        if (group2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/cli/DbCliUtil", "createComponents"));
        }
        if (constructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructor", "com/intellij/database/cli/DbCliUtil", "createComponents"));
        }
        List<CliComponent> list = Arrays.stream(group2.getArguments()).map(constructor).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "createComponents"));
        }
        return list;
    }

    @NotNull
    public static String extractParameterizable(String ... args) {
        String string = DbCliUtil.extract((Condition<String>)((Condition)s -> StringUtil.endsWith((CharSequence)s, (CharSequence)"=") || StringUtil.equals((CharSequence)"<", (CharSequence)s)), args);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "extractParameterizable"));
        }
        return string;
    }

    @NotNull
    public static String extractNonParameterizable(String ... args) {
        String string = DbCliUtil.extract((Condition<String>)((Condition)s -> !StringUtil.endsWith((CharSequence)s, (CharSequence)"=")), args);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "extractNonParameterizable"));
        }
        return string;
    }

    @NotNull
    private static String extract(@NotNull Condition<String> condition, String ... args) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DbCliUtil", "extract"));
        }
        if (args == null || args.length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "extract"));
            }
            return "";
        }
        String element = (String)ContainerUtil.find((Object[])args, condition);
        String string = StringUtil.notNullize((String)(element == null ? (String)ArrayUtil.getFirstElement((Object[])args) : element));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "extract"));
        }
        return string;
    }

    @NotNull
    public static String pgQuote(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/cli/DbCliUtil", "pgQuote"));
        }
        String string = "'" + DbCliUtil.quote(s) + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "pgQuote"));
        }
        return string;
    }

    @NotNull
    public static String quote(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/cli/DbCliUtil", "quote"));
        }
        String string = !DbCliUtil.containsNonAlphaCharacters(s) ? s : StringUtil.wrapWithDoubleQuote((String)DbCliUtil.escapeAllQuotes(s));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "quote"));
        }
        return string;
    }

    @NotNull
    public static String unescapeAll(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/cli/DbCliUtil", "unescapeAll"));
        }
        String string = StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)StringUtil.unescapeChar((String)s, (char)'\"'), (char)'\''), (char)'\\');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "unescapeAll"));
        }
        return string;
    }

    @NotNull
    public static String fromListToArgument(@NotNull List<String> strings, @NotNull String prefix, @NotNull Function<String, String> processor) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/cli/DbCliUtil", "fromListToArgument"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/cli/DbCliUtil", "fromListToArgument"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/DbCliUtil", "fromListToArgument"));
        }
        String string = StringUtil.join((Collection)ContainerUtil.map(strings, s -> {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/cli/DbCliUtil", "lambda$fromListToArgument$9"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/DbCliUtil", "lambda$fromListToArgument$9"));
            }
            return prefix + (String)processor.apply((String)s);
        }), (String)" ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "fromListToArgument"));
        }
        return string;
    }

    @Nullable
    public static String getArgumentValue(@NotNull String command, @NotNull List<String> parameterizable, @NotNull String[] args) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/DbCliUtil", "getArgumentValue"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/DbCliUtil", "getArgumentValue"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/DbCliUtil", "getArgumentValue"));
        }
        List<CliLexeme> lexemes = DbCliUtil.filteredLexemes(command, parameterizable);
        int index = ContainerUtil.lastIndexOf(lexemes, DbCliUtil.lexemeFinder(args));
        if (index == -1) {
            return null;
        }
        CliLexeme current = lexemes.get(index);
        CliLexeme next = index == lexemes.size() - 1 ? DbCliUtil.getLastCharacterLexeme(command) : lexemes.get(index + 1);
        return DbCliUtil.cutParameter(command, current, next);
    }

    @NotNull
    public static String[] withEquality(String ... strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/cli/DbCliUtil", "withEquality"));
        }
        List longArgs = ContainerUtil.findAll((Object[])strings, s -> StringUtil.startsWith((CharSequence)s, (CharSequence)"--"));
        String[] result2 = new String[strings.length + longArgs.size()];
        System.arraycopy(strings, 0, result2, 0, strings.length);
        for (int i2 = 0; i2 < longArgs.size(); ++i2) {
            result2[strings.length + i2] = (String)longArgs.get(i2) + "=";
        }
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "withEquality"));
        }
        return result2;
    }

    @NotNull
    static CliLexeme getLastCharacterLexeme(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "getLastCharacterLexeme"));
        }
        CliLexeme cliLexeme = new CliLexeme("", DbCliTokenType.BAD, text.length(), text.length());
        if (cliLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getLastCharacterLexeme"));
        }
        return cliLexeme;
    }

    @NotNull
    private static String getArgument(@NotNull String command, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliConfiguration.CliParameterProcessor processor, @NotNull List<String> parameterizable) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/DbCliUtil", "getArgument"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/DbCliUtil", "getArgument"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/DbCliUtil", "getArgument"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/DbCliUtil", "getArgument"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/DbCliUtil", "getArgument"));
        }
        String string = DbCliUtil.isParameterizable(current, parameterizable) ? DbCliUtil.getArgumentWithParameter(command, current, next, processor) : DbCliUtil.unescapeAll(StringUtil.unquoteString((String)current.getText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getArgument"));
        }
        return string;
    }

    @NotNull
    private static String getArgumentWithParameter(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliConfiguration.CliParameterProcessor processor) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "getArgumentWithParameter"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/DbCliUtil", "getArgumentWithParameter"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/DbCliUtil", "getArgumentWithParameter"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/DbCliUtil", "getArgumentWithParameter"));
        }
        String parameter = DbCliUtil.cutParameter(text, current, next);
        boolean needEquality = current.getType() == DbCliTokenType.LONG_PARAMETER && !current.getText().endsWith("=");
        String string = current.getText() + (needEquality && !StringUtil.isEmpty((String)DbCliUtil.unescapeAll(StringUtil.unquoteString((String)parameter))) ? "=" : "") + processor.process(current, parameter);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getArgumentWithParameter"));
        }
        return string;
    }

    @NotNull
    private static String escapeAllQuotes(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/cli/DbCliUtil", "escapeAllQuotes"));
        }
        String string = StringUtil.escapeChars((String)s, (char[])new char[]{'\\', '\"', '\''});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "escapeAllQuotes"));
        }
        return string;
    }

    private static void index(@NotNull Collection<CliLexeme> lexemes, @NotNull Lexer lexer) {
        IElementType type;
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/DbCliUtil", "index"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/cli/DbCliUtil", "index"));
        }
        List toSkip = ContainerUtil.list((Object[])new IElementType[]{DbCliTokenType.BAD, DbCliTokenType.VALUE});
        if (ContainerUtil.containsIdentity((Iterable)toSkip, (Object)(type = (IElementType)ObjectUtils.assertNotNull((Object)lexer.getTokenType())))) {
            return;
        }
        lexemes.add(DbCliUtil.lexeme(lexer));
    }

    @NotNull
    private static CliLexeme lexeme(@NotNull Lexer lexer) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/cli/DbCliUtil", "lexeme"));
        }
        CliLexeme cliLexeme = new CliLexeme(lexer.getTokenText(), (IElementType)ObjectUtils.assertNotNull((Object)lexer.getTokenType()), lexer.getTokenStart(), lexer.getTokenEnd());
        if (cliLexeme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "lexeme"));
        }
        return cliLexeme;
    }

    private static boolean containsNonAlphaCharacters(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/cli/DbCliUtil", "containsNonAlphaCharacters"));
        }
        for (int i2 = 0; i2 < value.length(); ++i2) {
            if (Character.isLetter(value.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<CliLexeme> getLexemes(@NotNull String text, @NotNull BiConsumer<List<CliLexeme>, Lexer> consumer) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/DbCliUtil", "getLexemes"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/cli/DbCliUtil", "getLexemes"));
        }
        ArrayList lexemes = ContainerUtil.newArrayList();
        DbCliLexerAdapter lexer = new DbCliLexerAdapter();
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            consumer.accept(lexemes, (Lexer)lexer);
            lexer.advance();
        }
        List list = ContainerUtil.sorted((Collection)lexemes);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getLexemes"));
        }
        return list;
    }

    @NotNull
    public static List<CliLexeme> filterLexemes(@NotNull List<CliLexeme> lexemes, @NotNull List<String> parameterizable) {
        Pair<CliLexeme, Integer> lexemeOffset;
        if (lexemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemes", "com/intellij/database/cli/DbCliUtil", "filterLexemes"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/DbCliUtil", "filterLexemes"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (int i2 = 0; i2 < lexemes.size(); i2 += (Integer)lexemeOffset.getSecond() + 1) {
            lexemeOffset = DbCliUtil.getCurrentLexemeWithOffset(lexemes, i2);
            CliLexeme current = (CliLexeme)lexemeOffset.getFirst();
            CliLexeme previous = i2 == 0 ? new CliLexeme("", DbCliTokenType.BAD, 0, 0) : lexemes.get(i2 - 1);
            boolean isPrevParameterizable = DbCliUtil.isParameterizable(previous, parameterizable);
            if (!current.isArgument() && isPrevParameterizable) continue;
            result2.add(current);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "filterLexemes"));
        }
        return arrayList;
    }

    @NotNull
    private static Pair<CliLexeme, Integer> getCurrentLexemeWithOffset(List<CliLexeme> lexemes, int index) {
        int offset = 0;
        while (index < lexemes.size() - 1 && lexemes.get(index).isWhitespaceOrBad()) {
            ++index;
            ++offset;
        }
        Pair pair = Pair.create((Object)lexemes.get(index), (Object)offset);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DbCliUtil", "getCurrentLexemeWithOffset"));
        }
        return pair;
    }

    private static boolean isParameterizable(@NotNull CliLexeme lexeme, @NotNull List<String> parameterizable) {
        if (lexeme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexeme", "com/intellij/database/cli/DbCliUtil", "isParameterizable"));
        }
        if (parameterizable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/DbCliUtil", "isParameterizable"));
        }
        return ArrayUtil.contains((String)lexeme.getText(), (String[])new String[]{"<", ">"}) || lexeme.isArgument() && (lexeme.getText().endsWith("=") || ContainerUtil.indexOf(parameterizable, (Object)lexeme.getText()) != -1);
    }
}

