/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.argument;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.BooleanCliArgument;
import com.intellij.database.cli.argument.BooleanCliArgumentImpl;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.argument.DefaultValueCliArgument;
import com.intellij.database.cli.argument.DefaultValueCliArgumentImpl;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.argument.StringCliArgumentImpl;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CommonPgCliArguments {
    public static final DefaultValueCliArgument F_DIRECTORY = new DefaultValueCliArgumentImpl.Parameterized("Directory", CommonPgArguments.FORMAT, CommonPgArguments.DIR_FORMAT);
    public static final DefaultValueCliArgument F_TAR = new DefaultValueCliArgumentImpl.Parameterized("Tar archive", CommonPgArguments.FORMAT, CommonPgArguments.TAR_FORMAT);
    public static final DefaultValueCliArgument F_CUSTOM = new DefaultValueCliArgumentImpl.Parameterized("Custom-format archive", CommonPgArguments.FORMAT, CommonPgArguments.CUSTOM_FORMAT);
    public static final BooleanCliArgument CLEAN = new BooleanCliArgumentImpl("Clean database", CommonPgArguments.CLEAN_DATABASE);
    public static final BooleanCliArgument CREATE = new BooleanCliArgumentImpl("Create database", CommonPgArguments.CREATE_DATABASE);
    public static final BooleanCliArgument IF_EXISTS = new BooleanCliArgumentImpl("Add \"IF EXISTS\"", "--if-exists");
    public static final BooleanCliArgument DATA_ONLY = new BooleanCliArgumentImpl("Data only", CommonPgArguments.DATA_ONLY);
    public static final StringCliArgument DATABASE = new StringCliArgumentImpl.MaybeUnnamedArgument("Database", (Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE), CommonPgArguments.DB_NAME);
    public static final StringCliArgument TABLES = new StringCliArgumentImpl("Tables", CommonPgArguments.TABLE){

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/argument/CommonPgCliArguments$1", "getStringsFromElements"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/CommonPgCliArguments$1", "getStringsFromElements"));
            }
            List<String> list = DbCliUtil.getTablesNames(elements);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/CommonPgCliArguments$1", "getStringsFromElements"));
            }
            return list;
        }
    };
    public static final StringCliArgument SCHEMAS = new StringCliArgumentImpl.ElementsStringArgument("Schemas", DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA), CommonPgArguments.SCHEMA){

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbCliUtil::pgQuote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/CommonPgCliArguments$2", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> unquoter = super.getUnquoter();
            Function<String, String> function = s -> StringUtil.unquoteString((String)((String)unquoter.apply((String)s)));
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/CommonPgCliArguments$2", "getUnquoter"));
            }
            return function;
        }
    };

    private CommonPgCliArguments() {
    }
}

