/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.argument;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.CliArgumentImpl;
import com.intellij.database.cli.argument.DefaultValueCliArgument;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultValueCliArgumentImpl
extends CliArgumentImpl
implements DefaultValueCliArgument {
    private final boolean myOnByDefault;

    public DefaultValueCliArgumentImpl(@NotNull String uiName, String ... options) {
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl", "<init>"));
        }
        this(uiName, false, options);
    }

    public DefaultValueCliArgumentImpl(@NotNull String uiName, boolean onByDefault, String ... options) {
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl", "<init>"));
        }
        super(uiName, options);
        this.myOnByDefault = onByDefault;
    }

    @Override
    public boolean isOnByDefault() {
        return this.myOnByDefault;
    }

    @Override
    @NotNull
    public String getCommandLineArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl", "getCommandLineArgument"));
        }
        String string = this.getArguments().length == 0 ? "" : this.getArguments()[0];
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl", "getCommandLineArgument"));
        }
        return string;
    }

    public static class Parameterized
    extends DefaultValueCliArgumentImpl {
        private final String[] myValues;

        public Parameterized(@NotNull String uiName, @NotNull String[] options, @NotNull String[] values) {
            if (uiName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "<init>"));
            }
            this(uiName, options, values, false);
        }

        public Parameterized(@NotNull String uiName, @NotNull String[] options, @NotNull String[] values, boolean onByDefault) {
            if (uiName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "<init>"));
            }
            super(uiName, onByDefault, options);
            this.myValues = values;
        }

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "isMyLexeme"));
            }
            return super.isMyLexeme(text, current, next, cd) && Parameterized.hasParameter(text, current, next, this.myValues);
        }

        @Override
        @NotNull
        public String getCommandLineArgument(@NotNull CliContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "getCommandLineArgument"));
            }
            String string = DbCliUtil.extractParameterizable(this.getArguments()) + DbCliUtil.extractNonParameterizable(this.myValues);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "getCommandLineArgument"));
            }
            return string;
        }

        protected static boolean hasParameter(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, String ... parameters) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "hasParameter"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "hasParameter"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "hasParameter"));
            }
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/cli/argument/DefaultValueCliArgumentImpl$Parameterized", "hasParameter"));
            }
            String parameter = DbCliUtil.cutParameter(text, current, next);
            return ArrayUtil.find((Object[])parameters, (Object)parameter) != -1;
        }
    }
}

