/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.component;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.component.CliUneditableTextField;
import com.intellij.database.psi.DbElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class CliSingleParameterUneditableTextField
extends CliUneditableTextField {
    public CliSingleParameterUneditableTextField(StringCliArgument argument) {
        super(argument);
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "getFullArgument"));
        }
        Function<String, String> quoter = ((StringCliArgument)this.getArgument()).getQuoter();
        String text = this.myField.getText();
        String string = text.isEmpty() ? "" : DbCliUtil.fromListToArgument(ContainerUtil.list((Object[])new String[]{text}), ((StringCliArgument)this.getArgument()).getPrefix(), quoter);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "getFullArgument"));
        }
        return string;
    }

    @Override
    public boolean configure(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "configure"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "configure"));
        }
        String item = (String)ContainerUtil.getFirstItem(((StringCliArgument)this.getArgument()).getStringsFromElements(elements, cd));
        this.myField.setText(item == null ? "" : item);
        return true;
    }

    @Override
    public void changeState(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "changeState"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "changeState"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "changeState"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliSingleParameterUneditableTextField", "changeState"));
        }
        StringCliArgument argument = (StringCliArgument)this.getArgument();
        String value = argument.getComponentValue(text, current, next, cd);
        if (value == null) {
            return;
        }
        String parameter = DbCliUtil.clearString(value, argument.getUnquoter());
        this.myField.setText(parameter);
    }
}

