/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore.pg;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.PostgresConfigurationBase;
import com.intellij.database.cli.SimpleCliDialogValidator;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.restore.pg.PsqlArguments;
import com.intellij.database.cli.restore.pg.PsqlArgumentsGroup;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PsqlConfiguration
extends PostgresConfigurationBase {
    public static final PsqlConfiguration INSTANCE = new PsqlConfiguration();

    private PsqlConfiguration() {
        super(PsqlArgumentsGroup.values(), CommonPgArguments.FILE, "PSQL_RESTORE_CONFIGURATION", "psql");
    }

    @Override
    @NotNull
    public String getPartOfValidationOut() {
        if ("psql" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration", "getPartOfValidationOut"));
        }
        return "psql";
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        Map<String, String> map = super.getInfoMap();
        PsqlConfiguration.put(map, "Zero byte for record separator", PsqlArguments.RECORD_SEPARATOR_ZERO);
        PsqlConfiguration.put(map, "Zero byte for field separator", PsqlArguments.FIELD_SEPARATOR_ZERO);
        PsqlConfiguration.put(map, "Print all queries", PsqlArguments.ECHO_QUERIES);
        PsqlConfiguration.put(map, "Single-step mode", PsqlArguments.SINGLE_STEP);
        PsqlConfiguration.put(map, "Show help", PsqlArguments.HELP);
        PsqlConfiguration.put(map, "Single-line mode", PsqlArguments.SINGLE_LINE);
        PsqlConfiguration.put(map, "Print queries generated by backslash commands", PsqlArguments.ECHO_HIDDEN);
        PsqlConfiguration.put(map, "Do not use readline", PsqlArguments.NO_READLINE);
        PsqlConfiguration.put(map, "Don't print columns, row count, etc", PsqlArguments.TUPLES_ONLY);
        PsqlConfiguration.put(map, "Don't read start-up file", PsqlArguments.NO_PSQLRC);
        PsqlConfiguration.put(map, "Print all input lines", PsqlArguments.ECHO_ALL);
        PsqlConfiguration.put(map, "Unaligned output", PsqlArguments.NO_ALIGN);
        PsqlConfiguration.put(map, "Expanded formatting mode", PsqlArguments.EXPANDED);
        PsqlConfiguration.put(map, "Quiet mode", PsqlArguments.QUIET);
        PsqlConfiguration.put(map, "Html output", PsqlArguments.HTML);
        PsqlConfiguration.put(map, "List all databases", PsqlArguments.LIST);
        PsqlConfiguration.put(map, "Record separator", PsqlArguments.RECORD_SEPARATOR);
        PsqlConfiguration.put(map, "Field separator", PsqlArguments.FIELD_SEPARATOR);
        PsqlConfiguration.put(map, "Options for <table> tag", PsqlArguments.TABLE_ATTRIBUTES);
        PsqlConfiguration.put(map, "Echo failed commands", PsqlArguments.ECHO_ERRORS);
        PsqlConfiguration.put(map, "Variable assignment", PsqlArguments.VARIABLE);
        PsqlConfiguration.put(map, "Additionally write output into file", PsqlArguments.LOG_FILE);
        PsqlConfiguration.put(map, "Command to execute", PsqlArguments.COMMAND);
        PsqlConfiguration.put(map, "Write output into file", PsqlArguments.OUTPUT);
        PsqlConfiguration.put(map, "Printing options", PsqlArguments.PSET);
        Map<String, String> map2 = map;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration", "getInfoMap"));
        }
        return map2;
    }

    @Override
    @NotNull
    public CliDialogValidator getValidator() {
        SimpleCliDialogValidator simpleCliDialogValidator = new SimpleCliDialogValidator(CommonPgArguments.FILE, CommonPgArguments.PASSWORD);
        if (simpleCliDialogValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration", "getValidator"));
        }
        return simpleCliDialogValidator;
    }

    @Override
    @NotNull
    public CliConfiguration.Operation getOperation() {
        CliConfiguration.Operation operation = CliConfiguration.Operation.RESTORE;
        if (operation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration", "getOperation"));
        }
        return operation;
    }

    @Override
    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer() {
        DatabaseObjectsPreparer databaseObjectsPreparer = super.getObjectsPreparer().onlyIfSingleElement((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().filter((Condition<DbElement>)((Condition)e -> e instanceof DbDataSource || e.getKind() == ObjectKind.DATABASE)).requireNotEmpty().onlyIfMoreThanOnce((Condition<DbElement>)DasUtil.byKind((ObjectKind)ObjectKind.DATABASE)).filter((Condition<DbElement>)Conditions.alwaysFalse()).finish().endIf().finish();
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration", "getObjectsPreparer"));
        }
        return databaseObjectsPreparer;
    }

    @Override
    @NotNull
    public CliConfiguration.CliBuilder getCliBuilder(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/restore/pg/PsqlConfiguration", "getCliBuilder"));
        }
        MyBuilder myBuilder = new MyBuilder(this.getParameterProcessor(), project, this.getOperation(), this.getName(), this.getEnvironmentVarName());
        if (myBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration", "getCliBuilder"));
        }
        return myBuilder;
    }

    private static class MyBuilder
    extends CliConfigurationBase.CliBuilderBase {
        public MyBuilder(@NotNull CliConfiguration.CliParameterProcessor processor, @NotNull Project project, @NotNull CliConfiguration.Operation operation, @NotNull String name, @NotNull String envName) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "<init>"));
            }
            if (operation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "<init>"));
            }
            if (envName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envName", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "<init>"));
            }
            super(processor, project, operation, name, envName);
        }

        @Override
        @NotNull
        protected List<String> getArguments(@NotNull List<String> parameterizable, @NotNull String command) {
            if (parameterizable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterizable", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "getArguments"));
            }
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "getArguments"));
            }
            ArrayList rawLexemes = ContainerUtil.newArrayList(DbCliUtil.rawLexemes(command));
            List lexemes = ContainerUtil.subList(DbCliUtil.filteredLexemes(command, parameterizable), (int)1);
            CliLexeme dbLexeme = (CliLexeme)ContainerUtil.find((Iterable)lexemes, l -> l.isParameter());
            if (dbLexeme == null) {
                List<String> list = super.getArguments(parameterizable, command);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "getArguments"));
                }
                return list;
            }
            CliLexeme lexeme = (CliLexeme)ContainerUtil.find((Iterable)rawLexemes, (Object)dbLexeme);
            CliLexeme last = (CliLexeme)ContainerUtil.getLastItem((List)rawLexemes);
            if (last == null || lexeme == null || !rawLexemes.remove(lexeme)) {
                List<String> list = super.getArguments(parameterizable, command);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "getArguments"));
                }
                return list;
            }
            rawLexemes.add(DbCliUtil.createLexeme((!last.isWhitespace() ? " " : "") + lexeme.getText(), false));
            List<String> list = super.getArguments(parameterizable, DbCliUtil.joinLexemes(rawLexemes));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PsqlConfiguration$MyBuilder", "getArguments"));
            }
            return list;
        }
    }
}

