/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.console.evaluation.AbstractTableResult;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationResultFetcher;
import com.intellij.database.console.evaluation.OwnerBasedExpressionEvaluator;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class EvaluationRequest
extends DataRequest.IsolatedQueryRequest
implements Disposable {
    protected final Project myProject;
    protected final DbDataSource mySource;
    protected final DatabaseDialectEx myDialect;
    protected final CompletableFuture<DatabaseExpressionEvaluator.Result> myFuture;
    private final List<DataConsumer.Row> myRows;
    private volatile DataConsumer.Column[] myColumns;
    private volatile boolean myDisposed;

    EvaluationRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future, @NotNull String query, @NotNull DbDataSource source) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/EvaluationRequest", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/EvaluationRequest", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/EvaluationRequest", "<init>"));
        }
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/console/evaluation/EvaluationRequest", "<init>"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/console/evaluation/EvaluationRequest", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/EvaluationRequest", "<init>"));
        }
        super(owner, owner.getCurrentTx(), query, DataRequest.newConstraints(0, 10, 0), null);
        this.myProject = project;
        this.myDialect = dialect;
        this.myFuture = future;
        this.mySource = source;
        this.myRows = ContainerUtil.createConcurrentList();
    }

    @Override
    public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/evaluation/EvaluationRequest", "setColumns"));
        }
        this.myColumns = infos;
    }

    @Override
    public void addRows(@NotNull DataRequest.Context context, @NotNull List<DataConsumer.Row> rows) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/evaluation/EvaluationRequest", "addRows"));
        }
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/evaluation/EvaluationRequest", "addRows"));
        }
        this.myRows.addAll(rows);
    }

    @Override
    public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/evaluation/EvaluationRequest", "afterLastRowAdded"));
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            boolean loaded;
            if (this.myDisposed) {
                return;
            }
            boolean bl = loaded = total <= this.myRows.size();
            if (this.myColumns != null) {
                ObjectFormatter.convertRows(this.myRows, ContainerUtil.list((Object[])this.myColumns));
            }
            this.myFuture.complete(this.myColumns == null ? null : (this.myRows.isEmpty() && this.myColumns.length == 0 ? new OwnerBasedExpressionEvaluator.EmptyResult() : this.createTableResult(loaded)));
            Disposer.dispose((Disposable)this);
        });
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    private AbstractTableResult createTableResult(boolean loaded) {
        List columns2 = ContainerUtil.list((Object[])this.myColumns);
        SqlLanguageDialect sqlDialect = DbSqlUtil.getSqlDialect((DbElement)this.mySource);
        DasTable table = DbSqlUtil.detectTable(this.myProject, (Language)sqlDialect, null, this.query, this, columns2);
        EvaluationResultFetcher evaluationResultFetcher = this.createFetcher(ContainerUtil.newArrayList(this.myRows), columns2, loaded);
        AbstractTableResult abstractTableResult = table == null ? new AbstractTableResult.TableResult(this.myDialect, evaluationResultFetcher) : new AbstractTableResult.DasTableResult(this.myDialect, evaluationResultFetcher, table);
        if (abstractTableResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationRequest", "createTableResult"));
        }
        return abstractTableResult;
    }

    @NotNull
    protected EvaluationResultFetcher createFetcher(@NotNull List<DataConsumer.Row> rows, @NotNull List<DataConsumer.Column> columns2, boolean loaded) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/evaluation/EvaluationRequest", "createFetcher"));
        }
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/evaluation/EvaluationRequest", "createFetcher"));
        }
        EvaluationResultFetcher evaluationResultFetcher = new EvaluationResultFetcher(rows, columns2, this.myProject, (DataRequest.OwnerEx)this.owner, this.mySource, this.myDialect, this.query, loaded);
        if (evaluationResultFetcher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationRequest", "createFetcher"));
        }
        return evaluationResultFetcher;
    }

    public void dispose() {
        this.myDisposed = true;
    }
}

