/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import org.jetbrains.annotations.NotNull;

public interface Cardinality
extends Comparable<Cardinality> {
    public static final Cardinality EMPTY = new Cardinality(){

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$1", "compareTo"));
            }
            return o == this ? 0 : -1;
        }
    };

    public static class FractionCardinality
    implements Cardinality {
        private final int myMax;

        public FractionCardinality(int max) {
            this.myMax = max;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$FractionCardinality", "compareTo"));
            }
            return o == EMPTY ? 1 : (!(o instanceof FractionCardinality) ? -1 : Integer.compare(this.myMax, ((FractionCardinality)o).myMax));
        }
    }

    public static class ScalableCardinality
    implements Cardinality {
        public static final int INFINITY = Integer.MAX_VALUE;
        private final int myPrecision;

        public ScalableCardinality(int precision) {
            this.myPrecision = precision;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$ScalableCardinality", "compareTo"));
            }
            return o instanceof TextCardinality ? -1 : (o instanceof ElementsCardinality ? 0 : (o instanceof MinMaxCardinality ? -o.compareTo(this) : (o instanceof ScalableCardinality ? this.compareWithScalable((ScalableCardinality)o) : 1)));
        }

        private int compareWithScalable(@NotNull ScalableCardinality cardinality) {
            if (cardinality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Cardinality$ScalableCardinality", "compareWithScalable"));
            }
            return this.myPrecision - cardinality.myPrecision;
        }
    }

    public static class MinMaxCardinality
    implements Cardinality {
        private final double myMin;
        private final double myMax;
        private final boolean myFloating;

        public MinMaxCardinality(double min, double max, boolean floating) {
            this.myMin = min;
            this.myMax = max;
            this.myFloating = floating;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$MinMaxCardinality", "compareTo"));
            }
            return o instanceof TextCardinality ? -1 : (o instanceof ElementsCardinality ? 0 : (o instanceof ScalableCardinality ? this.compareWithScalable() : (o instanceof MinMaxCardinality ? this.compareWithMinMax((MinMaxCardinality)o) : 1)));
        }

        private int compareWithScalable() {
            return this.myFloating ? 1 : -1;
        }

        private int compareWithMinMax(@NotNull MinMaxCardinality cardinality) {
            if (cardinality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Cardinality$MinMaxCardinality", "compareWithMinMax"));
            }
            return Double.compare(this.myMax - this.myMin, cardinality.myMax - cardinality.myMin);
        }
    }

    public static class ElementsCardinality
    implements Cardinality {
        private final long myMax;

        public ElementsCardinality(long max) {
            this.myMax = max;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$ElementsCardinality", "compareTo"));
            }
            return o instanceof MinMaxCardinality || o instanceof ScalableCardinality ? 0 : (o instanceof TextCardinality ? -1 : (o instanceof ElementsCardinality ? Long.compare(this.myMax, ((ElementsCardinality)o).myMax) : 1));
        }
    }

    public static class TextCardinality
    implements Cardinality {
        private final long myMax;

        public TextCardinality(long max) {
            this.myMax = max;
        }

        @Override
        public int compareTo(@NotNull Cardinality o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/data/types/domain/Cardinality$TextCardinality", "compareTo"));
            }
            return o instanceof TextCardinality ? Long.compare(this.myMax, ((TextCardinality)o).myMax) : 1;
        }
    }
}

