/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.PgNumber2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class PostgresBaseDomains
extends DomainRegistry {
    static final int MAX_FRACTION = 6;
    static final double MAX_REAL = 1.0E37;
    static final double MIN_REAL = -1.0E37;
    static final double MIN_DOUBLE = -1.0E307;
    static final double MAX_DOUBLE = 1.0E308;

    protected PostgresBaseDomains(@NotNull DatabaseDialect dialect, int maxPrecision, int maxScale, int maxChar, int maxVarchar) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/data/types/registry/PostgresBaseDomains", "<init>"));
        }
        super(dialect);
        this.add(new PgNumber2Domain("numeric", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add(new PgNumber2Domain("decimal", ConversionPoint.BIG_DECIMAL, maxPrecision, maxScale, true));
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("int4", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add(new FloatDomain("float8", ConversionPoint.DOUBLE_PRECISION, -1.0E307, 1.0E308));
        this.add(new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add(new FloatDomain("float4", ConversionPoint.SINGLE_PRECISION, -1.0E37, 1.0E37));
        this.add(new SimpleDomain("date", ConversionPoint.DATE, PhysicalDomainType.DATE));
        this.add(new TextDomain("text", ConversionPoint.TEXT, Integer.MAX_VALUE));
        this.add(new TextDomain("char", ConversionPoint.CHAR, maxChar, -1L, true));
        this.add(new TextDomain("bpchar", ConversionPoint.CHAR, maxChar, -1L, true));
        this.add(new TextDomain("character", ConversionPoint.CHAR, maxChar, -1L, true));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, maxVarchar, -1L, true));
        this.add(new TextDomain("character varying", ConversionPoint.VARCHAR, maxVarchar, -1L, true));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN));
        this.add(new BooleanDomain("bool", ConversionPoint.BOOLEAN));
    }

    static class MyZonedDomain
    extends FractionDomain {
        private final String myPrefix;

        public MyZonedDomain(@NotNull FractionDomain domain, @NotNull String prefix) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/PostgresBaseDomains$MyZonedDomain", "<init>"));
            }
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/database/data/types/registry/PostgresBaseDomains$MyZonedDomain", "<init>"));
            }
            super(domain.simpleName(), domain.getPoint(), domain.getDomainType(), domain.getMax(), domain.getDefaultValue(), domain.isNarrowable());
            this.myPrefix = prefix;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/PostgresBaseDomains$MyZonedDomain", "narrow"));
            }
            MyZonedDomain myZonedDomain = new MyZonedDomain((FractionDomain)super.narrow(domain), this.myPrefix);
            if (myZonedDomain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresBaseDomains$MyZonedDomain", "narrow"));
            }
            return myZonedDomain;
        }

        @Override
        @NotNull
        public Domain narrow(@NotNull SizeProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/data/types/registry/PostgresBaseDomains$MyZonedDomain", "narrow"));
            }
            MyZonedDomain myZonedDomain = new MyZonedDomain((FractionDomain)super.narrow(provider), this.myPrefix);
            if (myZonedDomain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresBaseDomains$MyZonedDomain", "narrow"));
            }
            return myZonedDomain;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.shouldParametrize() ? StringUtil.toUpperCase((String)this.myPrefix) + "(" + this.getMax() + ") WITH TIME ZONE" : super.name();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresBaseDomains$MyZonedDomain", "name"));
            }
            return string;
        }
    }
}

