/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class DataSourceNameComponent {
    private static final String NON_UNIQUE_NAME = "NON_UNIQUE_NAME";
    private final JComponent myPanel = new Box(0);
    private final JBTextField myName;
    private final AbstractDatabaseConfigurable myConfigurable;
    private final DatabaseConfigEditor myController;

    public DataSourceNameComponent(AbstractDatabaseConfigurable configurable, DatabaseConfigEditor controller) {
        this.myConfigurable = configurable;
        this.myController = controller;
        this.myName = new JBTextField();
        this.myName.setColumns(20);
        this.myName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String name = DataSourceNameComponent.this.getNameValue();
                if (!DataSourceNameComponent.this.myController.isObjectNameUnique(DataSourceNameComponent.this.myConfigurable.getTarget(), name)) {
                    DataSourceNameComponent.this.myController.showErrorNotification((Configurable)DataSourceNameComponent.this.myConfigurable, DataSourceNameComponent.NON_UNIQUE_NAME, "Name is Not Unique", String.format("Object with the name '%s' already exists. Please choose another name.", name), new Object[0]);
                } else {
                    DataSourceNameComponent.this.myController.showErrorNotification((Configurable)DataSourceNameComponent.this.myConfigurable, DataSourceNameComponent.NON_UNIQUE_NAME, null);
                }
            }
        });
        this.myPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        this.myPanel.add((Component)new JBLabel("Name:"));
        this.myPanel.add(Box.createHorizontalStrut(5));
        this.myPanel.add((Component)this.myName);
        this.myPanel.add(Box.createHorizontalStrut(15));
        JComponent reset = this.myController.createResetAction((Configurable)this.myConfigurable);
        if (reset != null) {
            this.myPanel.add(reset);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DataSourceNameComponent", "getComponent"));
        }
        return jComponent;
    }

    public String getNameValue() {
        return this.myName.getText().trim();
    }

    public void setGeneratedName(String name) {
        if (Comparing.equal((String)name, (String)this.myName.getText())) {
            return;
        }
        this.myName.setText(name);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    public void setNameValue(String name) {
        this.myName.setText(name);
    }
}

