/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.zipfs;

import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystem;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;

final class ZipCoder {
    private Charset cs;
    private boolean isutf8;
    private ZipCoder utf8;
    private final ThreadLocal<CharsetDecoder> decTL = new ThreadLocal();
    private final ThreadLocal<CharsetEncoder> encTL = new ThreadLocal();

    String toString(byte[] ba, int length) {
        CharBuffer cb;
        CharsetDecoder cd = this.decoder().reset();
        int len = (int)((float)length * cd.maxCharsPerByte());
        char[] ca = new char[len];
        if (len == 0) {
            return new String(ca);
        }
        ByteBuffer bb = ByteBuffer.wrap(ba, 0, length);
        CoderResult cr = cd.decode(bb, cb = CharBuffer.wrap(ca), true);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        cr = cd.flush(cb);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        return new String(ca, 0, cb.position());
    }

    String toString(byte[] ba) {
        return this.toString(ba, ba.length);
    }

    byte[] getBytes(String s) {
        CharsetEncoder ce = this.encoder().reset();
        char[] ca = s.toCharArray();
        int len = (int)((float)ca.length * ce.maxBytesPerChar());
        byte[] ba = new byte[len];
        if (len == 0) {
            return ba;
        }
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca);
        CoderResult cr = ce.encode(cb, bb, true);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        cr = ce.flush(bb);
        if (!cr.isUnderflow()) {
            throw new IllegalArgumentException(cr.toString());
        }
        if (bb.position() == ba.length) {
            return ba;
        }
        return Arrays.copyOf(ba, bb.position());
    }

    byte[] getBytesUTF8(String s) {
        if (this.isutf8) {
            return this.getBytes(s);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(Charset.forName("UTF-8"));
        }
        return this.utf8.getBytes(s);
    }

    String toStringUTF8(byte[] ba, int len) {
        if (this.isutf8) {
            return this.toString(ba, len);
        }
        if (this.utf8 == null) {
            this.utf8 = new ZipCoder(Charset.forName("UTF-8"));
        }
        return this.utf8.toString(ba, len);
    }

    boolean isUTF8() {
        return this.isutf8;
    }

    private ZipCoder(Charset cs) {
        this.cs = cs;
        this.isutf8 = cs.name().equals("UTF-8");
    }

    static ZipCoder get(Charset charset) {
        return new ZipCoder(charset);
    }

    static ZipCoder get(String csn) {
        try {
            return new ZipCoder(Charset.forName(csn));
        }
        catch (Throwable t) {
            ZipFileSystem.LOG.warn(t);
            return new ZipCoder(Charset.defaultCharset());
        }
    }

    private CharsetDecoder decoder() {
        CharsetDecoder dec = this.decTL.get();
        if (dec == null) {
            dec = this.cs.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.decTL.set(dec);
        }
        return dec;
    }

    private CharsetEncoder encoder() {
        CharsetEncoder enc = this.encTL.get();
        if (enc == null) {
            enc = this.cs.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.encTL.set(enc);
        }
        return enc;
    }
}

