/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.dbimport.HandleErrorTask;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportErrorHandler {
    private final BlockingQueue<List<ErrorRecord>> myQueue;
    private final Thread myThread;
    private final HandleErrorTask myErrorTask;
    private int myErrorsCount;

    ImportErrorHandler(@NotNull Project project, @NotNull ImportInfo info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "<init>"));
        }
        this.myQueue = new LinkedTransferQueue<List<ErrorRecord>>();
        this.myErrorTask = this.createErrorTask(project, info);
        this.myThread = this.shouldWriteErrorRecords() ? new Thread((Runnable)this.myErrorTask, "Import error handler") : null;
    }

    void start() {
        if (this.shouldWriteErrorRecords()) {
            this.myThread.start();
        }
    }

    void stop() {
        if (this.shouldWriteErrorRecords()) {
            this.onStop();
        }
    }

    void handle(@NotNull List<ErrorRecord> record) {
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "com/intellij/database/dbimport/ImportErrorHandler", "handle"));
        }
        this.myErrorsCount += record.size();
        if (!this.shouldWriteErrorRecords() || this.myErrorTask.isStopped() || record.isEmpty()) {
            return;
        }
        this.myQueue.add(record);
    }

    int getErrorsCount() {
        return this.myErrorsCount;
    }

    boolean shouldWriteErrorRecords() {
        return this.myErrorTask != null;
    }

    private void onStop() {
        this.myQueue.add(HandleErrorTask.POISON);
    }

    @Nullable
    private HandleErrorTask createErrorTask(@NotNull Project project, @NotNull ImportInfo info) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportErrorHandler", "createErrorTask"));
        }
        HandleErrorTask.ErrorTaskInfo errorTaskInfo = info.getErrorTaskInfo();
        String errorRecordsWriter = errorTaskInfo.getErrorRecordsPath();
        return errorRecordsWriter == null ? null : new HandleErrorTask(project, this.myQueue, info);
    }
}

