/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.diff.Migrator;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbForeignKey;
import com.intellij.database.psi.DbIndex;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableKey;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.QNameUtil;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiffElement
extends DiffElement<DbElement> {
    public static final String IGNORE_ORDER = "IGNORE_ORDER";
    public static final String IGNORE_CASE = "IGNORE_CASE";
    private final DbElement myElement;
    private DirDiffSettings mySettings;

    public DbDiffElement(DbElement element) {
        this.myElement = element;
    }

    public String getPresentablePath() {
        return this.myElement.getDataSource().getName() + ":/" + this.getPath();
    }

    public String getPath() {
        return this.getPath(this.getValue());
    }

    private String getPath(DbElement value) {
        if (value == null) {
            return "";
        }
        String name = this.getIdentifierMode().apply(value.getName());
        DbElement parent = value.getDbParent();
        if (value instanceof DbColumn) {
            return this.getPath(parent) + this.getSeparator() + name;
        }
        if (value instanceof DbTable) {
            return this.getPath(parent) + name;
        }
        return name.isEmpty() ? this.getPath(parent) : name + this.getSeparator();
    }

    @NotNull
    public String getName() {
        String string = (String)ReadAction.compute(() -> {
            String elementName = this.myElement.getName();
            if (StringUtil.isEmpty((String)elementName)) {
                if (this.myElement instanceof DbForeignKey) {
                    elementName = "foreign key";
                } else if (this.myElement instanceof DbTableKey) {
                    elementName = DasUtil.getPrimaryKey((DasTable)((DbTableKey)this.myElement).getTable()) == this.myElement ? "primary key" : "key";
                } else if (this.myElement instanceof DbIndex) {
                    boolean unique = ((DbIndex)this.myElement).isUnique();
                    elementName = unique ? "unique index" : "index";
                }
            }
            return this.getIdentifierMode().apply(elementName);
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "getName"));
        }
        return string;
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public FileType getFileType() {
        return SqlFileType.INSTANCE;
    }

    public boolean isContainer() {
        return !(this.myElement.getDelegate() instanceof DasTableChild);
    }

    public DiffElement[] getChildren() {
        List list = ContainerUtil.map((Iterable)this.myElement.getDataSource().getModel().traverser().children((Object)this.myElement), object -> {
            DbDiffElement element = new DbDiffElement((DbElement)object);
            element.setSettings(this.mySettings);
            return element;
        });
        return list.isEmpty() ? EMPTY_ARRAY : list.toArray(new DiffElement[list.size()]);
    }

    @NotNull
    public byte[] getContent() throws IOException {
        byte[] byArray = (byte[])ReadAction.compute(() -> {
            String text = new DdlBuilder().sort(this.isIgnoreOrder()).keywordCase(this.getKeywordMode()).identifierCase(Casing.create((Case)this.getIdentifierMode(), (Case)this.getIdentifierMode())).element((DasObject)this.myElement).getStatement();
            return text.getBytes(this.getCharset());
        });
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "getContent"));
        }
        return byArray;
    }

    @NotNull
    public DiffContent createDiffContent(@Nullable Project project, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/diff/DbDiffElement", "createDiffContent"));
        }
        DiffContent diffContent = (DiffContent)ApplicationManager.getApplication().runReadAction((ThrowableComputable)new ThrowableComputable<DiffContent, DiffRequestProducerException>(){

            public DiffContent compute() throws DiffRequestProducerException {
                try {
                    Project project = DbDiffElement.this.myElement.getProject();
                    SqlLanguageDialect language = DbSqlUtil.getSqlDialect(DbDiffElement.this.myElement);
                    PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
                    PsiFile psiFile = psiFileFactory.createFileFromText("a." + DbDiffElement.this.getFileType().getDefaultExtension(), (Language)language, (CharSequence)StringUtil.convertLineSeparators((String)new String(DbDiffElement.this.getContent())), false, true);
                    VirtualFile virtualFile = psiFile.getViewProvider().getVirtualFile();
                    if (virtualFile instanceof LightVirtualFile) {
                        ((LightVirtualFile)virtualFile).setWritable(false);
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    assert (document != null);
                    DocumentContent content = DiffContentFactory.getInstance().create(project, document, virtualFile);
                    content.putUserData(DiffUserDataKeys.LANGUAGE, (Object)language);
                    return content;
                }
                catch (IOException e) {
                    throw new DiffRequestProducerException((Throwable)e);
                }
            }
        });
        if (diffContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "createDiffContent"));
        }
        return diffContent;
    }

    @NotNull
    private Case getIdentifierMode() {
        Case case_ = this.isIgnoreCase() ? Case.LOWER : Case.MIXED;
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "getIdentifierMode"));
        }
        return case_;
    }

    @NotNull
    private Case getKeywordMode() {
        Case case_ = this.isIgnoreCase() ? Case.UPPER : Case.MIXED;
        if (case_ == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/DbDiffElement", "getKeywordMode"));
        }
        return case_;
    }

    private boolean isIgnoreOrder() {
        return (Boolean)this.getSettings().customSettings.get(IGNORE_ORDER);
    }

    private boolean isIgnoreCase() {
        return (Boolean)this.getSettings().customSettings.get(IGNORE_CASE);
    }

    @Nullable
    public DbElement getValue() {
        return this.myElement.isValid() ? this.myElement : null;
    }

    public Icon getIcon() {
        DbElement value = this.getValue();
        if (value == null) {
            return null;
        }
        Icon icon = value.getIcon();
        if (icon != null) {
            return icon;
        }
        return DbPresentation.getIcon(value.getKind());
    }

    public DirDiffSettings getSettings() {
        return this.mySettings;
    }

    public void setSettings(DirDiffSettings settings) {
        this.mySettings = settings;
    }

    public void generateMigrationStatements(DdlBuilder builder, DdlBuilder addKeyBuilder, DdlBuilder dropKeyBuilder, DatabaseDialectEx targetDialect) {
        DbElement o = this.getValue();
        if (o == null) {
            return;
        }
        Migrator<DbElement> migrator = Migrator.getMigrator(o);
        if (migrator != null) {
            migrator.script(o, builder, addKeyBuilder, dropKeyBuilder, targetDialect);
        } else {
            String action = targetDialect == null ? "drop" : "create";
            builder.plain(String.format("-- todo %s %s: %s", action, o.getTypeName(), o.getName())).newLine();
        }
    }

    public String toString() {
        return "DbDiffElement{kind=" + this.myElement.getKind() + ", name=" + QNameUtil.getQualifiedName(this.myElement) + '}';
    }
}

