/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicOverloadable;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.sybase.SybaseProcedure;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelUtil {
    public static final Comparator<? super BasicElement> DISPLAY_ORDER_COMPARATOR = (e1, e2) -> {
        String s1 = e1.getDisplayOrder();
        String s2 = e2.getDisplayOrder();
        return s1.compareTo(s2);
    };
    public static final Comparator<? super BasicArrangedElement> POSITIONS_COMPARATOR = (e1, e2) -> {
        short p2;
        short p1 = e1.getPosition();
        return p1 < (p2 = e2.getPosition()) ? -1 : (p1 > p2 ? 1 : 0);
    };

    @Nullable
    public static String nameOf(@Nullable BasicNamedElement element) {
        return element != null ? element.getRealName() : null;
    }

    @NotNull
    public static <T> List<T> listOfNN(T ... elements) {
        if (elements == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
            }
            return list;
        }
        int n = elements.length;
        switch (n) {
            case 0: {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
                }
                return list;
            }
            case 1: {
                T element = elements[0];
                List list = element != null ? Collections.singletonList(element) : Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
                }
                return list;
            }
        }
        ArrayList<T> list = new ArrayList<T>(n);
        for (T element : elements) {
            if (element == null) continue;
            list.add(element);
        }
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "listOfNN"));
        }
        return arrayList;
    }

    public static String calculateSybProcedureIdentity(short pos) {
        return Short.toString(pos);
    }

    public static String calculateRoutineIdentity(@Nullable String name, @NotNull Iterable<? extends DasArgument> args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/model/ModelUtil", "calculateRoutineIdentity"));
        }
        StringBuilder b = new StringBuilder();
        b.append(name);
        boolean w = false;
        b.append('(');
        for (DasArgument dasArgument : args) {
            if (!dasArgument.getArgumentDirection().isIn()) continue;
            if (w) {
                b.append(',');
            }
            b.append(dasArgument.getDataType().getSpecification());
            w = true;
        }
        b.append(')');
        return b.toString();
    }

    @NotNull
    public static String calculateOverloadableIdentity(@NotNull BasicOverloadable o, boolean includingSurrogate) {
        String name;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/model/ModelUtil", "calculateOverloadableIdentity"));
        }
        if (o instanceof SybaseProcedure) {
            String string = ModelUtil.calculateSybProcedureIdentity(((SybaseProcedure)o).getPosition());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "calculateOverloadableIdentity"));
            }
            return string;
        }
        BasicNamedElement ne = (BasicNamedElement)ObjectUtils.tryCast((Object)o, BasicNamedElement.class);
        String string = ne == null ? "" : (name = includingSurrogate ? ne.getRealName() : ne.getNaturalName());
        if (o instanceof BasicRoutine) {
            String string2 = ModelUtil.calculateRoutineIdentity(name, ((BasicRoutine)((Object)o)).getArguments());
            if (string2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "calculateOverloadableIdentity"));
            }
            return string2;
        }
        String string3 = String.valueOf(name);
        if (string3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/ModelUtil", "calculateOverloadableIdentity"));
        }
        return string3;
    }
}

