/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.EmptyFamily;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.util.DasUtil;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicLikeTable
extends BasicElement,
DasTable {
    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends BasicColumn> getColumns();

    @NotNull
    default public @NotNull Family<@NotNull ? extends BasicIndex> getIndices() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicLikeTable", "getIndices"));
        }
        return family;
    }

    @NotNull
    default public @NotNull Family<@NotNull ? extends BasicKey> getKeys() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicLikeTable", "getKeys"));
        }
        return family;
    }

    @NotNull
    default public @NotNull Family<@NotNull ? extends BasicForeignKey> getForeignKeys() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicLikeTable", "getForeignKeys"));
        }
        return family;
    }

    @NotNull
    default public @NotNull Family<@NotNull ? extends BasicCheck> getChecks() {
        Family family = EmptyFamily.by(this);
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicLikeTable", "getChecks"));
        }
        return family;
    }

    @Nullable
    default public BasicConstraint findConstraint(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/model/basic/BasicLikeTable", "findConstraint"));
        }
        return this.findChild(ModelConsts.CONSTRAINT_KINDS, name, BasicConstraint.class);
    }

    default public boolean isSystem() {
        return false;
    }

    default public boolean isTemporary() {
        return false;
    }

    @Nullable
    default public BasicKey getPrimaryKey() {
        return null;
    }

    @NotNull
    default public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn column) {
        BasicKey pk;
        if (column == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicLikeTable", "getColumnAttrs"));
            }
            return set;
        }
        String name = column.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (column instanceof BasicColumn && ((BasicColumn)column).getSequenceIdentity() != null) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        if ((pk = this.getPrimaryKey()) != null && pk.dependsOnColumn(name)) {
            set.add(DasColumn.Attribute.PRIMARY_KEY);
        }
        for (BasicForeignKey basicForeignKey : this.getForeignKeys()) {
            if (!basicForeignKey.dependsOnColumn(name)) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (BasicIndex basicIndex : this.getIndices()) {
            if (!basicIndex.dependsOnColumn(name)) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicLikeTable", "getColumnAttrs"));
        }
        return enumSet;
    }
}

