/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.hsql;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.hsql.HsqlModSchema;
import com.intellij.database.model.hsql.HsqlModSourceAware;
import com.intellij.database.model.hsql.HsqlModTable;
import com.intellij.database.model.hsql.HsqlTrigger;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HsqlModTrigger
extends HsqlTrigger,
HsqlModSourceAware,
BasicModNamedElement {
    @Override
    @NotNull
    public HsqlModTable getTable();

    @Override
    @NotNull
    default public HsqlModTable getDbParent() {
        HsqlModTable hsqlModTable = this.getTable();
        if (hsqlModTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlModTrigger", "getDbParent"));
        }
        return hsqlModTable;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends HsqlModTrigger> getParentFamily();

    @Override
    @NotNull
    default public HsqlModSchema getSchema() {
        HsqlModSchema hsqlModSchema = this.getTable().getSchema();
        if (hsqlModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlModTrigger", "getSchema"));
        }
        return hsqlModSchema;
    }

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlModTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/hsql/HsqlModTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setComment(@Nullable String var1);

    public void setTurn(@Nullable TrigTurn var1);

    public void setEvent(@NotNull Set<TrigEvent> var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/hsql/HsqlModTrigger", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String nameScripted = properties.get("NameScripted");
        String nameQuoted = properties.get("NameQuoted");
        String comment = properties.get("Comment");
        String turn = properties.get("Turn");
        String event = properties.get("Event");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (nameScripted != null) {
            this.setNameScripted(PropertyConverter.importBoolean(nameScripted));
        }
        if (nameQuoted != null) {
            this.setNameQuoted(PropertyConverter.importBoolean(nameQuoted));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (turn != null) {
            this.setTurn(PropertyConverter.importTrigTurn(turn));
        }
        if (event != null) {
            this.setEvent(PropertyConverter.importSetOfTrigEvent(event));
        }
    }
}

