/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.mssql.MsLikeMajorTable;
import com.intellij.database.model.mssql.MsSchemaObject;
import com.intellij.database.model.mssql.MsSourceAware;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.database.model.properties.TrigTurn;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsTrigger
extends MsSchemaObject,
MsSourceAware,
BasicTrigger,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TRIGGER;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public MsLikeMajorTable getTable();

    @Override
    @Nullable
    default public MsLikeMajorTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public MsLikeMajorTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends MsTrigger> getParentFamily() {
        return null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isEncrypted() {
        return false;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @NotNull
    default public Set<TrigEvent> getEvents() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getEvents"));
        }
        return set;
    }

    @NotNull
    default public Set<TrigEvent> getFirstEvents() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getFirstEvents"));
        }
        return set;
    }

    @NotNull
    default public Set<TrigEvent> getLastEvents() {
        Set<TrigEvent> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getLastEvents"));
        }
        return set;
    }

    @Override
    @Nullable
    default public TrigTurn getTurn() {
        return null;
    }

    default public boolean isNotForReplication() {
        return false;
    }

    @Override
    default public boolean isDisabled() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean disabled;
        boolean notForReplication;
        TrigTurn turn;
        Set<TrigEvent> lastEvents;
        Set<TrigEvent> firstEvents;
        Set<TrigEvent> events;
        Date modifiedTimestamp;
        Date createdTimestamp;
        boolean encrypted;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/mssql/MsTrigger", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (encrypted = this.isEncrypted()) {
            consumer.accept("Encrypted", PropertyConverter.export(encrypted));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if (!(events = this.getEvents()).isEmpty()) {
            consumer.accept("Events", PropertyConverter.exportSetOfTrigEvent(events));
        }
        if (!(firstEvents = this.getFirstEvents()).isEmpty()) {
            consumer.accept("FirstEvents", PropertyConverter.exportSetOfTrigEvent(firstEvents));
        }
        if (!(lastEvents = this.getLastEvents()).isEmpty()) {
            consumer.accept("LastEvents", PropertyConverter.exportSetOfTrigEvent(lastEvents));
        }
        if ((turn = this.getTurn()) != null) {
            consumer.accept("Turn", PropertyConverter.export(turn));
        }
        if (notForReplication = this.isNotForReplication()) {
            consumer.accept("NotForReplication", PropertyConverter.export(notForReplication));
        }
        if (disabled = this.isDisabled()) {
            consumer.accept("Disabled", PropertyConverter.export(disabled));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Encrypted", "CreatedTimestamp", "ModifiedTimestamp", "Events", "FirstEvents", "LastEvents", "Turn", "NotForReplication", "Disabled");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsTrigger", "getPropertyNames"));
        }
        return list;
    }

    @Override
    default public BasicSchema getSchema() {
        return this.getTable().getSchema();
    }
}

