/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.oracle;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DasCluster;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.families.SingletonFamily;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraClusterIndex;
import com.intellij.database.model.oracle.OraMajorObject;
import com.intellij.database.model.oracle.OraSchema;
import com.intellij.database.model.oracle.OraStoredSchemaObject;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OraCluster
extends OraMajorObject,
OraStoredSchemaObject,
DasCluster {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.CLUSTER;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCluster", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public OraSchema getSchema();

    @Override
    @Nullable
    default public OraSchema getDbParent() {
        return this.getSchema();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends OraCluster> getParentFamily() {
        return null;
    }

    @NotNull
    public @NotNull PositioningNamingFamily<@NotNull ? extends OraClusterColumn> getColumns();

    @NotNull
    public @NotNull SingletonFamily<@NotNull ? extends OraClusterIndex> getIndices();

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Arrays.asList(ObjectKind.COLUMN, ObjectKind.INDEX);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCluster", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List<Family> list = Arrays.asList(this.getColumns(), this.getIndices());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCluster", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append(this.getColumns()).append(this.getIndices());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCluster", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @Nullable
    default public Date getCreatedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public Date getModifiedTimestamp() {
        return null;
    }

    @Override
    @Nullable
    default public String getTablespaceName() {
        return null;
    }

    @Nullable
    default public ClusterType getClusterType() {
        return null;
    }

    default public boolean isSingleTable() {
        return false;
    }

    default public int getBlockSize() {
        return 0;
    }

    @Nullable
    default public String getHashExpression() {
        return null;
    }

    default public int getHashCardinality() {
        return 0;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        int hashCardinality;
        String hashExpression;
        int blockSize;
        boolean singleTable;
        ClusterType clusterType;
        String tablespaceName;
        Date modifiedTimestamp;
        Date createdTimestamp;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/oracle/OraCluster", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if ((createdTimestamp = this.getCreatedTimestamp()) != null) {
            consumer.accept("CreatedTimestamp", PropertyConverter.export(createdTimestamp));
        }
        if ((modifiedTimestamp = this.getModifiedTimestamp()) != null) {
            consumer.accept("ModifiedTimestamp", PropertyConverter.export(modifiedTimestamp));
        }
        if ((tablespaceName = this.getTablespaceName()) != null) {
            consumer.accept("TablespaceName", PropertyConverter.export(tablespaceName));
        }
        if ((clusterType = this.getClusterType()) != null) {
            consumer.accept("ClusterType", PropertyConverter.export((Enum)clusterType));
        }
        if (singleTable = this.isSingleTable()) {
            consumer.accept("SingleTable", PropertyConverter.export(singleTable));
        }
        if ((blockSize = this.getBlockSize()) != 0) {
            consumer.accept("BlockSize", PropertyConverter.export(blockSize));
        }
        if ((hashExpression = this.getHashExpression()) != null) {
            consumer.accept("HashExpression", PropertyConverter.export(hashExpression));
        }
        if ((hashCardinality = this.getHashCardinality()) != 0) {
            consumer.accept("HashCardinality", PropertyConverter.export(hashCardinality));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "CreatedTimestamp", "ModifiedTimestamp", "TablespaceName", "ClusterType", "SingleTable", "BlockSize", "HashExpression", "HashCardinality");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/oracle/OraCluster", "getPropertyNames"));
        }
        return list;
    }
}

