/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresConstraint;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgresbase.PostgresBaseForeignKey;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresForeignKey
extends PostgresConstraint,
PostgresBaseForeignKey,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresTable getTable();

    @Override
    @Nullable
    default public PostgresTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public PostgresTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresForeignKey> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public PostgresSchema getSchema() {
        PostgresTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    default public boolean isDeferrable() {
        return false;
    }

    @Override
    default public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getColNames"));
        }
        return list;
    }

    @Override
    default public long getRefTableId() {
        return 0L;
    }

    @Override
    @NotNull
    default public List<Short> getRefColPositions() {
        List<Short> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getRefColPositions"));
        }
        return list;
    }

    @Override
    @Nullable
    default public String getRefSchemaName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefTableName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefKeyName() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getRefColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getRefColNames"));
        }
        return list;
    }

    @Override
    @NotNull
    default public CascadeRule getOnDelete() {
        CascadeRule cascadeRule = CascadeRule.no_action;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getOnDelete"));
        }
        return cascadeRule;
    }

    @Override
    @NotNull
    default public CascadeRule getOnUpdate() {
        CascadeRule cascadeRule = CascadeRule.no_action;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getOnUpdate"));
        }
        return cascadeRule;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        CascadeRule onUpdate;
        CascadeRule onDelete;
        List<String> refColNames;
        String refKeyName;
        String refTableName;
        String refSchemaName;
        List<Short> refColPositions;
        long refTableId;
        List<String> colNames;
        boolean initiallyDeferred;
        boolean deferrable;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresForeignKey", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (deferrable = this.isDeferrable()) {
            consumer.accept("Deferrable", PropertyConverter.export(deferrable));
        }
        if (initiallyDeferred = this.isInitiallyDeferred()) {
            consumer.accept("InitiallyDeferred", PropertyConverter.export(initiallyDeferred));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if ((refTableId = this.getRefTableId()) != 0L) {
            consumer.accept("RefTableId", PropertyConverter.export(refTableId));
        }
        if (!(refColPositions = this.getRefColPositions()).isEmpty()) {
            consumer.accept("RefColPositions", PropertyConverter.exportListOfShort(refColPositions));
        }
        if ((refSchemaName = this.getRefSchemaName()) != null) {
            consumer.accept("RefSchemaName", PropertyConverter.export(refSchemaName));
        }
        if ((refTableName = this.getRefTableName()) != null) {
            consumer.accept("RefTableName", PropertyConverter.export(refTableName));
        }
        if ((refKeyName = this.getRefKeyName()) != null) {
            consumer.accept("RefKeyName", PropertyConverter.export(refKeyName));
        }
        if (!(refColNames = this.getRefColNames()).isEmpty()) {
            consumer.accept("RefColNames", PropertyConverter.exportListOfString(refColNames));
        }
        if ((onDelete = this.getOnDelete()) != null && onDelete != CascadeRule.no_action) {
            consumer.accept("OnDelete", PropertyConverter.export(onDelete));
        }
        if ((onUpdate = this.getOnUpdate()) != null && onUpdate != CascadeRule.no_action) {
            consumer.accept("OnUpdate", PropertyConverter.export(onUpdate));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "Deferrable", "InitiallyDeferred", "ColNames", "RefTableId", "RefColPositions", "RefSchemaName", "RefTableName", "RefKeyName", "RefColNames", "OnDelete", "OnUpdate");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresForeignKey", "getPropertyNames"));
        }
        return list;
    }
}

