/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.sqlite;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.sqlite.SqliteConstraint;
import com.intellij.database.model.sqlite.SqliteSchema;
import com.intellij.database.model.sqlite.SqliteTable;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SqliteForeignKey
extends SqliteConstraint,
BasicForeignKey,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public SqliteTable getTable();

    @Override
    @Nullable
    default public SqliteTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public SqliteTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingFamily<@NotNull ? extends SqliteForeignKey> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public SqliteSchema getSchema() {
        SqliteTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getColNames"));
        }
        return list;
    }

    @Override
    @Nullable
    default public String getRefSchemaName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefTableName() {
        return null;
    }

    @Override
    @Nullable
    default public String getRefKeyName() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getRefColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getRefColNames"));
        }
        return list;
    }

    @Override
    @NotNull
    default public CascadeRule getOnDelete() {
        CascadeRule cascadeRule = CascadeRule.no_action;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getOnDelete"));
        }
        return cascadeRule;
    }

    @Override
    @NotNull
    default public CascadeRule getOnUpdate() {
        CascadeRule cascadeRule = CascadeRule.no_action;
        if (cascadeRule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getOnUpdate"));
        }
        return cascadeRule;
    }

    @Override
    default public boolean isDeferrable() {
        return false;
    }

    @Override
    default public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean initiallyDeferred;
        boolean deferrable;
        CascadeRule onUpdate;
        CascadeRule onDelete;
        List<String> refColNames;
        String refKeyName;
        String refTableName;
        String refSchemaName;
        List<String> colNames;
        String comment;
        boolean nameQuoted;
        boolean nameScripted;
        boolean nameSurrogate;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/sqlite/SqliteForeignKey", "exportProperties"));
        }
        String name = this.getName();
        if (name != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if (nameScripted = this.isNameScripted()) {
            consumer.accept("NameScripted", PropertyConverter.export(nameScripted));
        }
        if (nameQuoted = this.isNameQuoted()) {
            consumer.accept("NameQuoted", PropertyConverter.export(nameQuoted));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if ((refSchemaName = this.getRefSchemaName()) != null) {
            consumer.accept("RefSchemaName", PropertyConverter.export(refSchemaName));
        }
        if ((refTableName = this.getRefTableName()) != null) {
            consumer.accept("RefTableName", PropertyConverter.export(refTableName));
        }
        if ((refKeyName = this.getRefKeyName()) != null) {
            consumer.accept("RefKeyName", PropertyConverter.export(refKeyName));
        }
        if (!(refColNames = this.getRefColNames()).isEmpty()) {
            consumer.accept("RefColNames", PropertyConverter.exportListOfString(refColNames));
        }
        if ((onDelete = this.getOnDelete()) != null && onDelete != CascadeRule.no_action) {
            consumer.accept("OnDelete", PropertyConverter.export(onDelete));
        }
        if ((onUpdate = this.getOnUpdate()) != null && onUpdate != CascadeRule.no_action) {
            consumer.accept("OnUpdate", PropertyConverter.export(onUpdate));
        }
        if (deferrable = this.isDeferrable()) {
            consumer.accept("Deferrable", PropertyConverter.export(deferrable));
        }
        if (initiallyDeferred = this.isInitiallyDeferred()) {
            consumer.accept("InitiallyDeferred", PropertyConverter.export(initiallyDeferred));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("Name", "NameSurrogate", "NameScripted", "NameQuoted", "Comment", "ColNames", "RefSchemaName", "RefTableName", "RefKeyName", "RefColNames", "OnDelete", "OnUpdate", "Deferrable", "InitiallyDeferred");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/sqlite/SqliteForeignKey", "getPropertyNames"));
        }
        return list;
    }
}

