/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.Language;
import org.jetbrains.annotations.NotNull;

public class DbPackageImpl
extends DbElementImpl<DasObject, DbElement>
implements DbPackage {
    DbPackageImpl(DbElement parent, @NotNull DasObject delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/psi/DbPackageImpl", "<init>"));
        }
        super(parent, delegate);
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((DasObject)this.myDelegate).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPackageImpl", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder sb = new StringBuilder();
        if (DbImplUtil.canConnectTo(this)) {
            this.scheduleAsyncDocumentationUpdate(sb, this::loadSlowDocumentationInner);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbPackageImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    private void loadSlowDocumentationInner(CharOut sb, ConnectionProvider provider) throws Exception {
        sb.append("<br><b>Definition:</b><br><code><pre>");
        StringBuilder builder = new StringBuilder();
        DbImplUtil.tryLoadPackageDefinition(provider, this, true, builder);
        sb.append(DbSqlUtil.sql2Html(this.getProject(), (Language)DbSqlUtil.getSqlDialect(this), builder));
        sb.append("</pre></code>");
    }
}

