/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.MeasuringDataAuditor;
import com.intellij.database.util.DbUIUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.lang.ref.WeakReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataAuditor
extends MeasuringDataAuditor {
    private final AbstractQueryLanguageConsole<?> myConsole;

    public ConsoleDataAuditor(AbstractQueryLanguageConsole<?> console) {
        this.myConsole = console;
        this.myConsole.getMessageBus().addAuditor(this);
    }

    @Override
    public void requestStarted(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "requestStarted"));
        }
        super.requestStarted(context);
        this.myConsole.setCurrentTx(context.txMarker);
        this.myConsole.updateConsoleOnRequestStarted(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onStarted();
        }
    }

    @Override
    public void requestFinished(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "requestFinished"));
        }
        super.requestFinished(context);
        this.myConsole.updateConsoleOnRequestFinished(context);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onFinished();
        }
    }

    @Override
    public void txCompleted(@NotNull DataRequest.Context context, boolean commit) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "txCompleted"));
        }
        super.txCompleted(context, commit);
        this.myConsole.updateConsoleOnTxCompleted(context, commit);
        this.myConsole.setCurrentTx(DataRequest.START_NEW);
    }

    @Override
    public void print(@NotNull DataRequest.Context context, @Nullable String message) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "print"));
        }
        if (StringUtil.isEmpty((String)message)) {
            return;
        }
        this.myConsole.getHistoryLogger().print(context, message);
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myConsole.getProject());
        if (statusBar != null) {
            statusBar.setInfo(message, this.myConsole.getToolWindowId());
        }
    }

    @Override
    public void warn(@NotNull DataRequest.Context context, @Nullable String message) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "warn"));
        }
        this.myConsole.getHistoryLogger().warn(context, message);
    }

    @Override
    public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "error"));
        }
        super.error(context, message, th);
        this.myConsole.getHistoryLogger().error(context, message, th);
        if (context.request instanceof ConsoleDataRequest) {
            ((ConsoleDataRequest)context.request).onError(message, th);
        }
        this.bringAttentionToOutput(context, true);
    }

    @Override
    protected void bringAttentionToOutput(@NotNull DataRequest.Context context, boolean isError) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "bringAttentionToOutput"));
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "lambda$bringAttentionToOutput$1"));
            }
            if (!this.myConsole.isValid()) {
                return;
            }
            ConsoleDataRequest cr = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class);
            boolean wasShowing = this.myConsole.getUi().getComponent().isShowing();
            Consumer runnable = aVoid -> {
                if (!this.myConsole.isValid()) {
                    return;
                }
                Content content = this.myConsole.getOutputContent();
                if (content != null) {
                    boolean focus;
                    this.myConsole.getUi().setBouncing(content, true);
                    boolean bl = focus = !wasShowing || isError && cr == null;
                    if (focus) {
                        this.myConsole.getUi().selectAndFocus(content, false, false);
                        this.myConsole.getHistoryLogger().scrollToEnd();
                    }
                }
            };
            if (!(cr == null || cr.queryIndex != 0 && cr.hasNext)) {
                this.myConsole.showConsole(true, false).done(runnable);
            } else {
                runnable.consume(null);
            }
        });
    }

    @Override
    protected void bringAttentionByNotification(@NotNull DataRequest.Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ConsoleDataAuditor", "bringAttentionByNotification"));
        }
        boolean hasErrors = this.getStat((DataRequest.Context)context).errorCount > 0L;
        NotificationType type = hasErrors ? NotificationType.ERROR : NotificationType.INFORMATION;
        String query = context.getQuery();
        String text = (query.isEmpty() ? "Request" : StringUtil.trimMiddle((String)query, (int)60)) + "... <a href=\"\">finished!</a>";
        ConsoleDataAuditor.fireBackToConsoleNotification(this.myConsole, type, text);
    }

    private static void fireBackToConsoleNotification(@NotNull AbstractQueryLanguageConsole<?> console, @NotNull NotificationType type, @NotNull String text) {
        if (console == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/run/ConsoleDataAuditor", "fireBackToConsoleNotification"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/run/ConsoleDataAuditor", "fireBackToConsoleNotification"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/run/ConsoleDataAuditor", "fireBackToConsoleNotification"));
        }
        String title = console.getTitle();
        final WeakReference consoleRef = new WeakReference(console);
        DatabaseNotifications.DATABASE_LONG_RUNNING_GROUP.createNotification(title, text, type, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/database/run/ConsoleDataAuditor$1", "hyperlinkActivated"));
                }
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ConsoleDataAuditor$1", "hyperlinkActivated"));
                }
                AbstractQueryLanguageConsole console = (AbstractQueryLanguageConsole)consoleRef.get();
                if (console != null) {
                    console.showConsole(true, false);
                } else {
                    notification.expire();
                }
            }
        }).notify(console.getProject());
        SystemNotifications.getInstance().notify("ConsoleDataAuditor", title, text);
    }
}

