/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.run.actions.TransactionAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.event.ListSelectionEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescriptionPopup {
    private final List<Item> myItems;
    private final String myTitle;

    public DescriptionPopup(@NotNull List<Item> items, @NotNull String title) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/run/ui/DescriptionPopup", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/run/ui/DescriptionPopup", "<init>"));
        }
        this.myItems = items;
        this.myTitle = title;
    }

    @NotNull
    public JBPopup build(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/run/ui/DescriptionPopup", "build"));
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.myTitle, (ActionGroup)this.createGroup(this.myItems), context, null, true, null);
        String text = ((Item)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(this.myItems))).description();
        popup.setAdText(text, 2);
        popup.addListSelectionListener(e -> {
            Item item = DescriptionPopup.getSelectedItem(e);
            if (item == null) {
                return;
            }
            String description = item.description();
            popup.setAdText(description, 2);
        });
        ListPopup listPopup = popup;
        if (listPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup", "build"));
        }
        return listPopup;
    }

    @Nullable
    private static Item getSelectedItem(ListSelectionEvent e) {
        Object source = e.getSource();
        PopupFactoryImpl.ActionItem actionItem = (PopupFactoryImpl.ActionItem)ObjectUtils.tryCast((Object)PlatformDataKeys.SELECTED_ITEM.getData((DataProvider)source), PopupFactoryImpl.ActionItem.class);
        MyCheckBoxAdapter adapter = actionItem == null ? null : (MyCheckBoxAdapter)((Object)ObjectUtils.tryCast((Object)actionItem.getAction(), MyCheckBoxAdapter.class));
        return adapter == null ? null : adapter.myItem;
    }

    @NotNull
    DefaultActionGroup createGroup(@NotNull List<Item> items) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/run/ui/DescriptionPopup", "createGroup"));
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ContainerUtil.map(items, i2 -> i2.createAction()));
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup", "createGroup"));
        }
        return defaultActionGroup;
    }

    @NotNull
    private static String withLineBreak(@NotNull String base, @NotNull String beforeBreak) {
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/database/run/ui/DescriptionPopup", "withLineBreak"));
        }
        if (beforeBreak == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeBreak", "com/intellij/database/run/ui/DescriptionPopup", "withLineBreak"));
        }
        int idx = base.indexOf(beforeBreak);
        String withBreak = idx == -1 ? base : base.substring(0, idx + beforeBreak.length()) + "<br>" + base.substring(idx + beforeBreak.length());
        String string = "<html>" + withBreak + "</html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup", "withLineBreak"));
        }
        return string;
    }

    private static class IsolationItem
    implements CheckItem {
        private final TransactionAction.TxIsolation myIsolation;
        private final TxPopup.TxIsolationSelector mySelector;

        private IsolationItem(@NotNull TransactionAction.TxIsolation isolation, @NotNull TxPopup.TxIsolationSelector selector) {
            if (isolation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "isolation", "com/intellij/database/run/ui/DescriptionPopup$IsolationItem", "<init>"));
            }
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$IsolationItem", "<init>"));
            }
            this.myIsolation = isolation;
            this.mySelector = selector;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.myIsolation.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$IsolationItem", "name"));
            }
            return string;
        }

        @Override
        @NotNull
        public String description() {
            String string = TxSettingsPopup.DESCRIPTIONS.get((Object)this.myIsolation);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$IsolationItem", "description"));
            }
            return string;
        }

        @Override
        public void chosen(AnActionEvent e) {
            this.mySelector.select(this.myIsolation, e);
        }

        @Override
        public boolean isSelected() {
            return this.mySelector.isSelected(this.myIsolation);
        }
    }

    public static class TxSettingsPopup
    extends TxPopup {
        public static final Map<TransactionAction.TxIsolation, String> DESCRIPTIONS = ContainerUtil.map2Map((Collection)ContainerUtil.list((Object[])new Pair[]{Pair.create((Object)((Object)TransactionAction.TxIsolation.DEFAULT), (Object)DescriptionPopup.access$400("Current database transaction isolation level", "transaction ")), Pair.create((Object)((Object)TransactionAction.TxIsolation.READ_UNCOMMITTED), (Object)DescriptionPopup.access$400("Current transaction may detect uncommitted changes", "may ")), Pair.create((Object)((Object)TransactionAction.TxIsolation.READ_COMMITTED), (Object)DescriptionPopup.access$400("Current transaction detects only committed changes", "detects ")), Pair.create((Object)((Object)TransactionAction.TxIsolation.REPEATABLE_READ), (Object)DescriptionPopup.access$400("Current transaction never detects concurrent changes", "never ")), Pair.create((Object)((Object)TransactionAction.TxIsolation.SERIALIZABLE), (Object)DescriptionPopup.access$400("Concurrent execution has the same effect as serial", "has "))}));

        public TxSettingsPopup(@NotNull List<TransactionAction.TxIsolation> levels, @NotNull TxPopup.TxIsolationSelector selector) {
            if (levels == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "levels", "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup", "<init>"));
            }
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup", "<init>"));
            }
            super(TxSettingsPopup.createItems(levels, selector), selector);
        }

        @NotNull
        public static List<Item> createItems(@NotNull List<TransactionAction.TxIsolation> levels, @NotNull TxPopup.TxIsolationSelector selector) {
            if (levels == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "levels", "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup", "createItems"));
            }
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup", "createItems"));
            }
            List list = levels.isEmpty() ? ContainerUtil.emptyList() : JBIterable.of((Object)new SeparatorItem("Isolation Level")).filter(Item.class).append((Iterable)JBIterable.from(levels).map(l -> {
                if (selector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup", "lambda$createItems$0"));
                }
                return new IsolationItem((TransactionAction.TxIsolation)((Object)l), selector);
            })).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$TxSettingsPopup", "createItems"));
            }
            return list;
        }
    }

    public static class TxPopup
    extends DescriptionPopup {
        public static final String AUTO = "Auto";
        public static final String MANUAL = "Manual";
        public static final String AUTO_DESCRIPTION = "Changes submitted to the database are auto-committed";
        public static final String MANUAL_DESCRIPTION = "Manually commit changes submitted to the database";

        public TxPopup(@NotNull TxSelector selector) {
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxPopup", "<init>"));
            }
            this((List<Item>)ContainerUtil.emptyList(), selector);
        }

        TxPopup(@NotNull List<Item> items, @NotNull TxSelector selector) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/run/ui/DescriptionPopup$TxPopup", "<init>"));
            }
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxPopup", "<init>"));
            }
            super(TxPopup.createItems(items, selector), "Transaction Control");
        }

        @NotNull
        private static List<Item> createItems(@NotNull List<Item> items, @NotNull TxSelector selector) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/run/ui/DescriptionPopup$TxPopup", "createItems"));
            }
            if (selector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxPopup", "createItems"));
            }
            List list = JBIterable.of((Object[])new CheckItem[]{new TxAuto(selector), new TxManual(selector)}).filter(Item.class).append(items).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$TxPopup", "createItems"));
            }
            return list;
        }

        private static class TxManual
        implements CheckItem {
            private final TxSelector mySelector;

            private TxManual(@NotNull TxSelector selector) {
                if (selector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxManual", "<init>"));
                }
                this.mySelector = selector;
            }

            @Override
            @NotNull
            public String name() {
                if (TxPopup.MANUAL == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxManual", "name"));
                }
                return TxPopup.MANUAL;
            }

            @Override
            @NotNull
            public String description() {
                String string = DescriptionPopup.withLineBreak(TxPopup.MANUAL_DESCRIPTION, "changes ");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxManual", "description"));
                }
                return string;
            }

            @Override
            public void chosen(AnActionEvent e) {
                this.mySelector.toggle(e, false);
            }

            @Override
            public boolean isSelected() {
                return !this.mySelector.isAuto();
            }
        }

        private static class TxAuto
        implements CheckItem {
            private final TxSelector mySelector;

            private TxAuto(@NotNull TxSelector selector) {
                if (selector == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selector", "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxAuto", "<init>"));
                }
                this.mySelector = selector;
            }

            @Override
            @NotNull
            public String name() {
                if (TxPopup.AUTO == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxAuto", "name"));
                }
                return TxPopup.AUTO;
            }

            @Override
            @NotNull
            public String description() {
                String string = DescriptionPopup.withLineBreak(TxPopup.AUTO_DESCRIPTION, "the ");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$TxPopup$TxAuto", "description"));
                }
                return string;
            }

            @Override
            public void chosen(AnActionEvent e) {
                this.mySelector.toggle(e, true);
            }

            @Override
            public boolean isSelected() {
                return this.mySelector.isAuto();
            }
        }

        public static class TxSelectorImpl
        implements TxSelector {
            private boolean myMode;

            @Override
            public void toggle(@Nullable AnActionEvent e, boolean auto) {
                this.myMode = auto;
            }

            @Override
            public boolean isAuto() {
                return this.myMode;
            }
        }

        public static interface TxIsolationSelector
        extends TxSelector {
            public boolean isSelected(@NotNull TransactionAction.TxIsolation var1);

            public void select(@NotNull TransactionAction.TxIsolation var1, AnActionEvent var2);
        }

        public static interface TxSelector {
            public void toggle(@Nullable AnActionEvent var1, boolean var2);

            public boolean isAuto();
        }
    }

    public static class SeparatorItem
    implements Item {
        private final String myText;

        public SeparatorItem(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/run/ui/DescriptionPopup$SeparatorItem", "<init>"));
            }
            this.myText = text;
        }

        @Override
        @NotNull
        public String name() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$SeparatorItem", "name"));
            }
            return string;
        }

        @Override
        @NotNull
        public String description() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$SeparatorItem", "description"));
            }
            return "";
        }

        @Override
        public void chosen(AnActionEvent e) {
        }

        @Override
        @NotNull
        public AnAction createAction() {
            Separator separator = new Separator(this.myText);
            if (separator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$SeparatorItem", "createAction"));
            }
            return separator;
        }
    }

    static interface CheckItem
    extends Item {
        public boolean isSelected();

        @Override
        @NotNull
        default public AnAction createAction() {
            MyCheckBoxAdapter myCheckBoxAdapter = new MyCheckBoxAdapter(this);
            if (myCheckBoxAdapter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/DescriptionPopup$CheckItem", "createAction"));
            }
            return myCheckBoxAdapter;
        }
    }

    static interface Item {
        @NotNull
        public String name();

        @NotNull
        public String description();

        public void chosen(AnActionEvent var1);

        @NotNull
        public AnAction createAction();
    }

    private static class MyCheckBoxAdapter
    extends CheckboxAction {
        private final CheckItem myItem;

        private MyCheckBoxAdapter(@NotNull CheckItem item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/run/ui/DescriptionPopup$MyCheckBoxAdapter", "<init>"));
            }
            super(item.name(), StringUtil.removeHtmlTags((String)item.description()), null);
            this.myItem = item;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myItem.isSelected();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                this.myItem.chosen(e);
            }
        }
    }
}

