/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.util.TokenPatternMatcher;
import com.intellij.openapi.util.text.StringUtil;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public class TokenPattern {
    private final RunAutomaton myAutomaton;
    private final Pattern myPattern;
    private static boolean ourValidate = false;

    public TokenPattern(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/util/TokenPattern", "<init>"));
        }
        try {
            this.myAutomaton = new RunAutomaton(new RegExp(new BricsRegexConverter(pattern).getBrics()).toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider()));
            if (this.myAutomaton.newMatcher((CharSequence)"").find()) {
                throw new PatternSyntaxException("Should not match empty sequence", pattern, 0);
            }
        }
        catch (IllegalArgumentException e) {
            throw new PatternSyntaxException(e.getMessage(), pattern, 0);
        }
        this.myPattern = Pattern.compile(pattern);
    }

    public Matcher newMatcher() {
        return new Matcher();
    }

    public static void setValidate(boolean v) {
        ourValidate = v;
    }

    private static class BricsRegexConverter {
        private StringBuilder myResult = new StringBuilder();
        private CharSequence myPattern;
        private int myIndex = 0;
        private boolean myCaseInsensitive = false;

        public BricsRegexConverter(CharSequence pattern) {
            this.myPattern = pattern;
            this.process();
        }

        private void process() {
            while (this.processOne()) {
            }
        }

        public String getBrics() {
            return this.myResult.toString();
        }

        private boolean processOne() {
            if (this.myIndex >= this.myPattern.length()) {
                return false;
            }
            char c = this.myPattern.charAt(this.myIndex);
            switch (c) {
                case ')': {
                    return false;
                }
                case '(': {
                    this.processGroup();
                    break;
                }
                case '[': {
                    this.processClass();
                    break;
                }
                case '\\': {
                    this.processEscape();
                    break;
                }
                default: {
                    this.processChar();
                }
            }
            return true;
        }

        private void processChar() {
            char c = this.myPattern.charAt(this.myIndex);
            if (c == '#' || c == '@' || c == '\"' || c == '<') {
                this.escaped(c);
            } else {
                char c2 = c;
                if (this.myCaseInsensitive && (c2 = StringUtil.toUpperCase((char)c)) == c) {
                    c2 = StringUtil.toLowerCase((char)c);
                }
                if (c2 == c) {
                    this.myResult.append(c);
                } else {
                    this.myResult.append("[").append(c).append(c2).append("]");
                }
            }
            ++this.myIndex;
        }

        private void processEscape() {
            ++this.myIndex;
            if (this.myIndex >= this.myPattern.length()) {
                this.myResult.append("\\");
                return;
            }
            char c = this.myPattern.charAt(this.myIndex);
            ++this.myIndex;
            switch (c) {
                case 'D': 
                case 'd': {
                    this.charClass("0-9", c == 'd');
                    break;
                }
                case 'S': 
                case 's': {
                    this.charClassNamed("whitespacechar", c == 's');
                    break;
                }
                case 'W': 
                case 'w': {
                    this.charClass("a-zA-Z_0-9", c == 'w');
                    break;
                }
                case 'p': {
                    int end;
                    int b = this.myIndex < this.myPattern.length() ? (int)this.myPattern.charAt(this.myIndex) : 65535;
                    int n = end = b != 123 ? -1 : StringUtil.indexOf((CharSequence)this.myPattern, (char)'}', (int)this.myIndex);
                    if (end == -1) {
                        this.escaped(c);
                    } else {
                        this.charClassNamed(this.myPattern.subSequence(this.myIndex + 1, end), true);
                        this.myIndex = end + 1;
                    }
                }
                default: {
                    this.escaped(c);
                }
            }
        }

        private void processClass() {
            boolean found;
            int end = StringUtil.indexOf((CharSequence)this.myPattern, (char)']', (int)this.myIndex);
            boolean bl = found = end != -1;
            if (!found) {
                end = this.myPattern.length();
            }
            ++this.myIndex;
            this.myResult.append('[');
            while (this.myIndex < end) {
                char c = this.myPattern.charAt(this.myIndex);
                if (c == '&' || c == '*' || c == '?' || c == '\"' || c == '<' || c == '#' || c == '@' || c == '.') {
                    this.escaped(c);
                } else {
                    this.myResult.append(c);
                }
                ++this.myIndex;
            }
            this.myResult.append(']');
            this.myIndex = end + 1;
        }

        private void processGroup() {
            ++this.myIndex;
            boolean discard = false;
            int state = this.myResult.length();
            if (this.myPattern.length() > this.myIndex && this.myPattern.charAt(this.myIndex) == '?') {
                char c;
                ++this.myIndex;
                char c2 = c = this.myPattern.length() > this.myIndex ? this.myPattern.charAt(this.myIndex) : (char)'\u0000';
                if (c == 'i') {
                    this.myCaseInsensitive = true;
                }
                discard = c != ':';
                ++this.myIndex;
            }
            this.myResult.append("(");
            this.process();
            if (this.myPattern.length() > this.myIndex && this.myPattern.charAt(this.myIndex) == ')') {
                this.myResult.append(")");
                ++this.myIndex;
            }
            if (discard) {
                this.myResult.setLength(state);
            }
        }

        private void charClass(CharSequence cl, boolean positive) {
            this.myResult.append("[");
            if (!positive) {
                this.myResult.append("^");
            }
            this.myResult.append(cl);
            this.myResult.append("]");
        }

        private void charClassNamed(CharSequence cl, boolean positive) {
            if (!positive) {
                this.myResult.append("~");
            }
            this.myResult.append("<");
            this.myResult.append(cl);
            this.myResult.append(">");
        }

        private void escaped(char c) {
            this.myResult.append("\\").append(c);
        }
    }

    public class Matcher {
        private CharSequence myBuffer;
        private MatchResult myResult;
        private TokenPatternMatcher myMatcher;
        private java.util.regex.Matcher myPreciseMatcher;

        public void reset(CharSequence buffer) {
            this.myBuffer = buffer;
            this.myMatcher = new TokenPatternMatcher(buffer, TokenPattern.this.myAutomaton);
            this.myPreciseMatcher = TokenPattern.this.myPattern.matcher(this.myBuffer);
            this.myResult = null;
        }

        public int start() {
            return this.myResult.start();
        }

        public int end() {
            return this.myResult.end();
        }

        public boolean find(int start, int end) {
            start = Math.min(start, this.myBuffer.length());
            end = Math.min(end, this.myBuffer.length());
            this.myMatcher.reset(start, end);
            this.myResult = null;
            while (this.myMatcher.find()) {
                this.processCaptures(this.myMatcher.start(), this.myMatcher.end());
                if (this.myResult == null) continue;
            }
            if (ourValidate) {
                boolean res;
                java.util.regex.Matcher javaMatcher = TokenPattern.this.myPattern.matcher(this.myBuffer).region(start, end + 100);
                javaMatcher.useAnchoringBounds(false);
                javaMatcher.useTransparentBounds(true);
                boolean bl = res = javaMatcher.find() && javaMatcher.start() < end;
                assert (res == (this.myResult != null));
                if (res) {
                    assert (this.myResult.start() == javaMatcher.start());
                    assert (this.myResult.end() == javaMatcher.end());
                }
            }
            return this.myResult != null;
        }

        private boolean processCaptures(int start, int end) {
            this.myPreciseMatcher.region(start, end);
            this.myPreciseMatcher.useAnchoringBounds(false);
            this.myPreciseMatcher.useTransparentBounds(true);
            if (this.myPreciseMatcher.lookingAt()) {
                this.myResult = this.myPreciseMatcher;
                return true;
            }
            return false;
        }

        public MatchResult getResult() {
            return this.myResult;
        }
    }
}

