/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.dataSource.inspections;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.database.vendors.mssql.dataSource.inspections.DriverPortInstanceInspector;
import org.jetbrains.annotations.NotNull;

public class JtdsPortInstanceInspector
extends DriverPortInstanceInspector {
    @Override
    protected boolean canInspectInstanceOf(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/intellij/database/vendors/mssql/dataSource/inspections/JtdsPortInstanceInspector", "canInspectInstanceOf"));
        }
        return "net.sourceforge.jtds.jdbc.Driver".equals(driver.getDriverClass()) && "TSQL".equals(driver.getSqlDialect());
    }

    @Override
    protected void addWarning(@NotNull UrlEditorInspector.InspectionConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/vendors/mssql/dataSource/inspections/JtdsPortInstanceInspector", "addWarning"));
        }
        consumer.warning("Specified instance is running on the other port", "For JTDS driver instance name will take precedence over port", DETECT_PORT_FIX);
    }
}

