/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.codeInsight.TargetElementEvaluatorEx2;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.OpenDataFileDescriptor;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseTargetElementEvaluator
extends TargetElementEvaluatorEx2 {
    @Nullable
    public PsiElement getElementByReference(@NotNull PsiReference ref, int flags) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/view/DatabaseTargetElementEvaluator", "getElementByReference"));
        }
        return null;
    }

    @Nullable
    public PsiElement getGotoDeclarationTarget(@NotNull PsiElement element, @Nullable PsiElement navElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseTargetElementEvaluator", "getGotoDeclarationTarget"));
        }
        if (!(element instanceof DbElement)) {
            return null;
        }
        return DatabaseTargetElementEvaluator.createToSourceNavigatable((DbElement)element);
    }

    @NotNull
    public static PsiElement createToSourceNavigatable(final @NotNull DbElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/view/DatabaseTargetElementEvaluator", "createToSourceNavigatable"));
        }
        Project project = element.getProject();
        PsiElement psiElement = PomService.convertToPsi((Project)project, (PomTarget)new PomTarget(){

            public boolean isValid() {
                return element.isValid();
            }

            public void navigate(boolean requestFocus) {
                DatabaseTargetElementEvaluator.navigateToSource(element, requestFocus);
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        });
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/DatabaseTargetElementEvaluator", "createToSourceNavigatable"));
        }
        return psiElement;
    }

    public static void navigateToSource(@NotNull DbElement dbElement, boolean requestFocus) {
        if (dbElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/database/view/DatabaseTargetElementEvaluator", "navigateToSource"));
        }
        Project project = dbElement.getProject();
        DbElement navigateTo = DbNodeDescriptor.adjustForNavigation(dbElement);
        VirtualFile file = DbImplUtil.findSourceVirtualFile(navigateTo, true);
        if (file != null) {
            Runnable runnable = () -> {
                if (dbElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbElement", "com/intellij/database/view/DatabaseTargetElementEvaluator", "lambda$navigateToSource$0"));
                }
                int offset = OpenDataFileDescriptor.calcTargetOffset(project, file, (DasObject)dbElement);
                new OpenFileDescriptor(project, file, offset).navigate(requestFocus);
            };
            if (file instanceof DatabaseElementVirtualFileImpl) {
                DatabaseEditorHelper.reloadIfNeeded((DatabaseElementVirtualFileImpl)file).done(unused -> ApplicationManager.getApplication().invokeLater(runnable, project.getDisposed()));
            } else {
                runnable.run();
            }
        } else {
            DatabaseView.select(dbElement, requestFocus);
        }
    }
}

