/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelTraverserEx
extends DdlPreview.ModelTraverser {
    private static final Condition<DeObject> INTERNAL_DECLARATIONS = object -> {
        PsiElement child = (PsiElement)DbRenamePsiElementProcessor.getElementOfType(object, SqlElement.class);
        PsiElement parent = (PsiElement)DbRenamePsiElementProcessor.getElementOfType(object.getParent(), SqlElement.class);
        return child == null || parent == null || !PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)child, (boolean)false);
    };
    private static final Condition<DasObject> MODIFIED_CHILD_EXPAND = new Condition<DasObject>(){

        public boolean value(DasObject object) {
            Collection<DeObject> ignoreChildren2;
            DeTable table = (DeTable)ObjectUtils.tryCast((Object)object, DeTable.class);
            if (table == null || !(table.editedObject instanceof DeObject)) {
                return NORMAL_EXPAND.value((Object)object);
            }
            DeTable deEdited = (DeTable)ObjectUtils.tryCast((Object)table.editedObject, DeTable.class);
            Collection<DeObject> ignoreChildren1 = this.getIgnoredChildren(table);
            return !table.isAlteredIgnoringChild((DeObject)table.editedObject, ignoreChildren1, ignoreChildren2 = this.getIgnoredChildren(deEdited));
        }

        @NotNull
        private Collection<DeObject> getIgnoredChildren(@Nullable DeTable deEdited) {
            Set set = deEdited != null ? JBIterable.from(deEdited.indices).append(deEdited.foreignKeys).append((Iterable)deEdited.keys).filter(INTERNAL_DECLARATIONS).toSet() : Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ModelTraverserEx$1", "getIgnoredChildren"));
            }
            return set;
        }
    };
    private static final Condition<DasObject> NORMAL_EXPAND = object -> ((DeObject)object).lightExported;
    private final TableDialogSettings.Settings mySettings;
    private final EditorModelBase myModelBase;
    private final DeModel myModel;

    public ModelTraverserEx(@NotNull TableDialogSettings.Settings settings, @NotNull EditorModelBase modelBase, @NotNull DeModel model) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/view/ModelTraverserEx", "<init>"));
        }
        if (modelBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelBase", "com/intellij/database/view/ModelTraverserEx", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/ModelTraverserEx", "<init>"));
        }
        super(modelBase.getModel());
        this.mySettings = settings;
        this.myModelBase = modelBase;
        this.myModel = model;
    }

    @Override
    @NotNull
    public JBIterable<SchemaEditorHelper.ObjectAction> traverse() {
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)this.model.traverser().withRoots(this.getRoots())).expandAndSkip(this.getExpansionMethod())).filter(DeObject.class).intercept(this.getActionGenerator());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ModelTraverserEx", "traverse"));
        }
        return jBIterable;
    }

    @NotNull
    private Function<Iterator<DeObject>, Iterator<SchemaEditorHelper.ObjectAction>> getActionGenerator() {
        Function function = iterator -> JBIterable.once((Iterator)iterator).flatten((Function)new GenericEditingResultProcessor.AppendDroppedSiblings(this.mySettings)).iterator();
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ModelTraverserEx", "getActionGenerator"));
        }
        return function;
    }

    @NotNull
    private JBIterable<? extends DeObject> getRoots() {
        JBIterable jBIterable = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.ALTER_CODE ? this.myModel.getModelRoots().filter(DeObject.class) : this.myModelBase.getEditedObjects();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ModelTraverserEx", "getRoots"));
        }
        return jBIterable;
    }

    @NotNull
    private Condition<DasObject> getExpansionMethod() {
        boolean isReplace = this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL;
        boolean isAppend = this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL;
        boolean isCreateNewCode = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE;
        Condition<DasObject> condition = isReplace || isAppend && isCreateNewCode ? MODIFIED_CHILD_EXPAND : NORMAL_EXPAND;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ModelTraverserEx", "getExpansionMethod"));
        }
        return condition;
    }
}

