/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.ThreeStateCheckBox;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseEditorBase
implements Disposable {
    protected boolean myUpdating;
    private final DatabaseEditorState myState;

    public DatabaseEditorBase(@NotNull DatabaseEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseEditorBase", "<init>"));
        }
        this.myState = state;
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myState.context;
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorBase", "getContext"));
        }
        return databaseEditorContext;
    }

    public Project getProject() {
        return this.getContext().getProject();
    }

    @NotNull
    public abstract EditorModelBase getModel();

    protected void updateFromModel() {
        this.myUpdating = true;
        try {
            this.updateFromModelImpl();
        }
        finally {
            this.myUpdating = false;
        }
    }

    protected void markInvalid() {
        this.myState.markInvalid(this);
    }

    protected void markValid() {
        this.myState.markValid(this);
    }

    public boolean areEditorsValid() {
        return this.myState.areAllEditorsValid();
    }

    protected abstract void updateFromModelImpl();

    protected static void setValue(@NotNull EditorTextField field, @NotNull String value) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/database/view/editors/DatabaseEditorBase", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/view/editors/DatabaseEditorBase", "setValue"));
        }
        if (!value.equals(field.getText())) {
            field.setText(value);
        }
    }

    protected static void setValue(@NotNull JCheckBox field, boolean value) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/database/view/editors/DatabaseEditorBase", "setValue"));
        }
        if (value != field.isSelected()) {
            field.setSelected(value);
        }
    }

    protected static void setValue(@NotNull ThreeStateCheckBox field, ThreeState value) {
        ThreeStateCheckBox.State state;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/database/view/editors/DatabaseEditorBase", "setValue"));
        }
        ThreeStateCheckBox.State state2 = value == ThreeState.YES ? ThreeStateCheckBox.State.SELECTED : (state = value == ThreeState.NO ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
        if (state != field.getState()) {
            field.setState(state);
        }
    }

    protected static void setValue(@NotNull JTextField field, @NotNull String value) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/database/view/editors/DatabaseEditorBase", "setValue"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/view/editors/DatabaseEditorBase", "setValue"));
        }
        if (!value.equals(field.getText())) {
            field.setText(value);
        }
    }

    @NotNull
    public abstract JComponent getComponent();

    @NotNull
    public abstract JComponent getPreferredFocusedComponent();

    public void dispose() {
        this.markValid();
    }

    @NotNull
    public String getObjectName(@Nullable DeObject ref) {
        String string = ref == null ? "" : this.getContext().getDialect().quoteIdentifier(ref.name, false, false);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DatabaseEditorBase", "getObjectName"));
        }
        return string;
    }

    public DatabaseEditorState getState() {
        return this.myState;
    }
}

