/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeTableKey;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableChildEditorModel;
import com.intellij.sql.util.NameTemplate;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TableKeyEditorModel
extends TableChildEditorModel<DeTableKey> {
    private final EditorModelUtil.GeneratedNameHelper myGenHelper;

    public TableKeyEditorModel(@NotNull DeTableKey object, @NotNull EditorModelsCache models) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/TableKeyEditorModel", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/TableKeyEditorModel", "<init>"));
        }
        super(object, models);
        this.fix();
        this.myGenHelper = new EditorModelUtil.GeneratedNameHelper(object, (NameTemplate)new NameTemplate.PrimaryKeyNameTemplate(models.settings));
        this.myGenHelper.updateGenerated();
    }

    private void fix() {
        List columns2 = ((DeTableKey)this.myObject).columns;
        for (int i2 = 0; i2 < columns2.size(); ++i2) {
            DeColumn column = (DeColumn)columns2.get(i2);
            if (column != null) continue;
            columns2.set(i2, EditorModelUtil.stubbize(column, ((DeTableKey)this.myObject).table, ((DeTableKey)this.myObject).model));
        }
    }

    @NotNull
    public List<DeColumn> getColumns() {
        List<DeColumn> list = Collections.unmodifiableList(((DeTableKey)this.myObject).columns);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/TableKeyEditorModel", "getColumns"));
        }
        return list;
    }

    public void setColumns(@NotNull List<DeColumn> columns2) {
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/view/models/TableKeyEditorModel", "setColumns"));
        }
        if (((DeTableKey)this.myObject).columns.equals(columns2)) {
            return;
        }
        ((DeTableKey)this.myObject).columns.clear();
        ((DeTableKey)this.myObject).columns.addAll(columns2);
        this.modify();
    }

    public int getColumnsCount() {
        return ((DeTableKey)this.myObject).columns.size();
    }

    @Override
    public void commit() {
        if (this.myGenHelper.updateGenerated()) {
            this.modify();
        }
        super.commit();
    }
}

