/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlTypeInfoProvider
extends ExpressionTypeProvider<SqlExpression> {
    @NotNull
    public String getInformationHint(@NotNull SqlExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/SqlTypeInfoProvider", "getInformationHint"));
        }
        String string = StringUtil.escapeXml((String)element.getSqlType().toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlTypeInfoProvider", "getInformationHint"));
        }
        return string;
    }

    @NotNull
    public String getErrorHint() {
        if ("No SQL expression found" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlTypeInfoProvider", "getErrorHint"));
        }
        return "No SQL expression found";
    }

    @NotNull
    public List<SqlExpression> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementAt", "com/intellij/sql/SqlTypeInfoProvider", "getExpressionsAt"));
        }
        List list = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(SqlExpression.class).toList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/SqlTypeInfoProvider", "getExpressionsAt"));
        }
        return list;
    }
}

