/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.util.containers.ContainerUtil;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePatternSerialization {
    private static final Logger LOG = Logger.getInstance(TreePatternSerialization.class);

    public static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePattern pattern) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        if (pattern.root != null && pattern.root.groups.length != 0) {
            TreePatternSerialization.serialize(writer, pattern.root);
        }
    }

    @Nullable
    public static TreePattern deserialize(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/sql/dialects/TreePatternSerialization", "deserialize"));
        }
        TreePatternNode<TreePatternNode.NegativeNaming> node = TreePatternSerialization.deserializeNode(reader, TreePatternNode.NegativeNaming.class);
        return node == null ? null : new TreePattern(node);
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode<?> node) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        writer.startNode("node");
        if (node.naming instanceof TreePatternNode.NegativeNaming) {
            writer.addAttribute("negative", "1");
        }
        for (ObjectName objectName : ((TreePatternNode.BaseNaming)node.naming).names) {
            TreePatternSerialization.serialize(writer, objectName);
        }
        for (TreePatternNode.Group group2 : node.groups) {
            TreePatternSerialization.serialize(writer, group2);
        }
        writer.endNode();
    }

    @Nullable
    private static <T extends TreePatternNode.BaseNaming> TreePatternNode<T> deserializeNode(@NotNull HierarchicalStreamReader reader, Class<T> namingClass) {
        boolean neg2;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/sql/dialects/TreePatternSerialization", "deserializeNode"));
        }
        if (!"node".equals(reader.getNodeName())) {
            return null;
        }
        boolean neg1 = "1".equals(reader.getAttribute("negative"));
        boolean bl = neg2 = namingClass == TreePatternNode.NegativeNaming.class;
        if (neg1 != neg2) {
            LOG.warn("Unexpected naming type");
            return null;
        }
        List names = ContainerUtil.newSmartList();
        List groups = ContainerUtil.newSmartList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String tag = reader.getNodeName();
            if ("name".equals(tag)) {
                ObjectName name = TreePatternSerialization.deserializeName(reader);
                if (name == null) {
                    return null;
                }
                names.add(name);
            } else if ("group".equals(tag)) {
                TreePatternNode.Group group2 = TreePatternSerialization.deserializeGroup(reader);
                if (group2 == null) {
                    return null;
                }
                groups.add(group2);
            }
            reader.moveUp();
        }
        T naming = TreePatternSerialization.instantiateNaming(namingClass, names);
        return new TreePatternNode<T>(naming, groups.toArray(new TreePatternNode.Group[groups.size()]));
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull TreePatternNode.Group group2) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        if (group2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        writer.startNode("group");
        writer.addAttribute("kind", group2.kind.code());
        if (group2.negativeChild != null) {
            TreePatternSerialization.serialize(writer, group2.negativeChild);
        }
        if (group2.positiveChildren != null) {
            for (TreePatternNode<TreePatternNode.PositiveNaming> child : group2.positiveChildren) {
                TreePatternSerialization.serialize(writer, child);
            }
        }
        writer.endNode();
    }

    @Nullable
    private static TreePatternNode.Group deserializeGroup(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/sql/dialects/TreePatternSerialization", "deserializeGroup"));
        }
        String code = reader.getAttribute("kind");
        if (code == null) {
            return null;
        }
        ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(code);
        if (kind == null && code.equals(SqlImportUtil.DATA_SOURCE.code())) {
            kind = SqlImportUtil.DATA_SOURCE;
        }
        if (kind == null) {
            LOG.warn("Unable to find kind: " + code);
            return null;
        }
        TreePatternNode<TreePatternNode.NegativeNaming> n = null;
        List p = ContainerUtil.newSmartList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("node".equals(reader.getNodeName())) {
                boolean neg = "1".equals(reader.getAttribute("negative"));
                if (neg) {
                    if (n != null) {
                        LOG.warn("Unexpected second negative naming");
                        return null;
                    }
                    n = TreePatternSerialization.deserializeNode(reader, TreePatternNode.NegativeNaming.class);
                    if (n == null) {
                        return null;
                    }
                } else {
                    TreePatternNode<TreePatternNode.PositiveNaming> node = TreePatternSerialization.deserializeNode(reader, TreePatternNode.PositiveNaming.class);
                    if (node == null) {
                        return null;
                    }
                    p.add(node);
                }
            }
            reader.moveUp();
        }
        return new TreePatternNode.Group(kind, p.isEmpty() ? null : p.toArray(new TreePatternNode[p.size()]), n);
    }

    private static void serialize(@NotNull HierarchicalStreamWriter writer, @NotNull ObjectName name) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/sql/dialects/TreePatternSerialization", "serialize"));
        }
        writer.startNode("name");
        writer.addAttribute("name", name.name);
        if (name.quoted) {
            writer.addAttribute("quoted", "1");
        }
        writer.endNode();
    }

    @Nullable
    private static ObjectName deserializeName(HierarchicalStreamReader reader) {
        String name = reader.getAttribute("name");
        if (name == null) {
            return null;
        }
        boolean quoted = "1".equals(reader.getAttribute("quoted"));
        return new ObjectName(name, quoted);
    }

    @NotNull
    private static <T extends TreePatternNode.BaseNaming> T instantiateNaming(@NotNull Class<T> namingClass, List<ObjectName> names) {
        if (namingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namingClass", "com/intellij/sql/dialects/TreePatternSerialization", "instantiateNaming"));
        }
        if (namingClass == TreePatternNode.NegativeNaming.class) {
            TreePatternNode.NegativeNaming negativeNaming = new TreePatternNode.NegativeNaming(ObjectName.toArray(names));
            if (negativeNaming == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternSerialization", "instantiateNaming"));
            }
            return (T)negativeNaming;
        }
        if (namingClass == TreePatternNode.PositiveNaming.class) {
            TreePatternNode.PositiveNaming positiveNaming = new TreePatternNode.PositiveNaming(ObjectName.toArray(names));
            if (positiveNaming == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/dialects/TreePatternSerialization", "instantiateNaming"));
            }
            return (T)positiveNaming;
        }
        throw new AssertionError((Object)("Unexpected " + namingClass.getSimpleName()));
    }
}

