/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlIntentionUtil {
    @Nullable
    static SqlIdentifier getIdentifier(PsiElement at) {
        PsiElement element = at != null ? at.getParent() : null;
        return element instanceof SqlIdentifier ? (SqlIdentifier)element : null;
    }

    public static void qualifyReference(@NotNull Iterable<String> names, @NotNull SqlIdentifier identifier) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/intentions/SqlIntentionUtil", "qualifyReference"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/intentions/SqlIntentionUtil", "qualifyReference"));
        }
        SqlLanguageDialectEx dialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)identifier);
        String quoted = StringUtil.join((Iterable)JBIterable.from(names).transform(name -> {
            if (identifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/intentions/SqlIntentionUtil", "lambda$qualifyReference$0"));
            }
            return dialectEx.quoteIdentifier(identifier.getProject(), (String)name);
        }), (String)".");
        PsiFile file = identifier.getContainingFile();
        if (file == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)identifier.getProject()).getDocument(file);
        if (document == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)identifier.getProject(), (String)"Qualify identifier", null, () -> {
            if (identifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/intentions/SqlIntentionUtil", "lambda$qualifyReference$1"));
            }
            document.insertString(identifier.getTextRange().getStartOffset(), (CharSequence)(quoted + "."));
        }, (PsiFile[])new PsiFile[]{file});
    }

    public static void qualifyReference(@NotNull List<? extends Iterable<String>> names, final @NotNull SqlIdentifier identifier, @NotNull Editor editor) {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/intellij/sql/intentions/SqlIntentionUtil", "qualifyReference"));
        }
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/sql/intentions/SqlIntentionUtil", "qualifyReference"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/sql/intentions/SqlIntentionUtil", "qualifyReference"));
        }
        if (names.isEmpty()) {
            return;
        }
        LinkedHashSet namesSet = ContainerUtil.newLinkedHashSet(names);
        final ArrayList uniqueNames = ContainerUtil.newArrayList((Iterable)namesSet);
        if (uniqueNames.size() == 1) {
            SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get(0), identifier);
            return;
        }
        final ArrayList qualified = ContainerUtil.newArrayList();
        for (Iterable name : uniqueNames) {
            qualified.add(StringUtil.join((Iterable)name, (String)".") + "." + identifier.getName());
        }
        JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Integer>("Qualify With...", JBIterable.generate((Object)0, x -> x + 1).take(qualified.size()).toList()){

            @NotNull
            public String getTextFor(Integer value) {
                String string = (String)qualified.get(value);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/intentions/SqlIntentionUtil$1", "getTextFor"));
                }
                return string;
            }

            public PopupStep onChosen(Integer selectedValue, boolean finalChoice) {
                SqlIntentionUtil.qualifyReference((Iterable)uniqueNames.get(selectedValue), identifier);
                return FINAL_CHOICE;
            }
        }).showInBestPositionFor(editor);
    }
}

