/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.psi.stubs.SqlConstraintStub;
import com.intellij.sql.psi.stubs.SqlStubbedTypedDefinitionImpl;
import com.intellij.util.ArrayFactory;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlColumnDefinitionImpl
extends SqlStubbedTypedDefinitionImpl<SqlColumnStub>
implements SqlColumnDefinition,
SqlExtraDeclarationsProvider {
    public SqlColumnDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public SqlColumnDefinitionImpl(SqlColumnStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_COLUMN_DEFINITION);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlColumnDefinition((SqlColumnDefinition)this);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_COLUMN_SHORT_REFERENCE;
    }

    public SqlIdentifier getNameElement() {
        SqlColumnStub stub = (SqlColumnStub)this.getStub();
        if (stub != null) {
            SqlReferenceExpression reference = stub.getNameReference(SqlCompositeElementTypes.SQL_COLUMN_REFERENCE);
            return reference == null ? null : reference.getIdentifier();
        }
        return (SqlIdentifier)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.COLUMN;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getKind"));
        }
        return objectKind;
    }

    @NotNull
    public List<SqlConstraintDefinition> getConstraints() {
        SqlColumnStub stub = (SqlColumnStub)this.getStub();
        if (stub != null) {
            ArrayList res = ContainerUtil.newArrayList();
            for (StubElement element : stub.getChildrenStubs()) {
                if (!(element instanceof SqlConstraintStub)) continue;
                res.add(((SqlConstraintStub)element).getPsi());
            }
            ArrayList arrayList = res;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getConstraints"));
            }
            return arrayList;
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlConstraintDefinition.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getConstraints"));
        }
        return list;
    }

    public SqlTableKeyDefinition getPrimaryKey() {
        return (SqlTableKeyDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION);
    }

    public SqlForeignKeyDefinition getForeignKey() {
        return (SqlForeignKeyDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION);
    }

    public SqlTableKeyDefinition getUniqueKey() {
        return (SqlTableKeyDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_UNIQUE_KEY_DEFINITION);
    }

    @NotNull
    public PsiReference[] getReferences() {
        DasTable table = this.getTable();
        SqlIdentifier nameElement = this.getNameElement();
        if (nameElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange textRange = nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent());
        SmartList result2 = new SmartList();
        Processor processor = arg_0 -> this.lambda$getReferences$0(textRange, (List)result2, arg_0);
        if (table instanceof SqlDefinition) {
            ContainerUtil.process(SqlImplUtil.getReferencedElements((SqlDefinition)table), (Processor)processor);
        } else if (table != null) {
            processor.process((Object)table);
        }
        PsiReference[] psiReferenceArray = (PsiReference[])ContainerUtil.toArray((Collection)result2, (ArrayFactory)PsiReference.ARRAY_FACTORY);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    public DasTable getTable() {
        SqlCreateTableStatement createStmt = (SqlCreateTableStatement)this.getStubOrPsiParentOfType(SqlCreateTableStatement.class);
        if (createStmt != null) {
            return createStmt;
        }
        SqlAlterTableStatement alterStmt = (SqlAlterTableStatement)this.getStubOrPsiParentOfType(SqlAlterTableStatement.class);
        if (alterStmt != null) {
            ResolveResult[] results;
            SqlReferenceExpression targetRef = alterStmt.getAlterTargetReference();
            for (ResolveResult resolveResult : results = targetRef == null ? ResolveResult.EMPTY_ARRAY : targetRef.multiResolve(true)) {
                PsiElement element = resolveResult.getElement();
                if (!(element instanceof DasTable)) continue;
                return (DasTable)element;
            }
            return SqlImplUtil.NO_TABLE;
        }
        return SqlImplUtil.NO_TABLE;
    }

    @Override
    public boolean isNotNull() {
        SqlColumnStub stub = (SqlColumnStub)this.getStub();
        if (stub != null) {
            return !stub.isNullable();
        }
        for (PsiElement element : this.getChildren()) {
            if (!(element instanceof SqlConstraintDefinition)) continue;
            SqlConstraintDefinition.Type type = ((SqlConstraintDefinition)element).getConstraintType();
            if (type == SqlConstraintDefinition.Type.NOT_NULL) {
                return true;
            }
            if (type != SqlConstraintDefinition.Type.NULLABLE) continue;
            return false;
        }
        return false;
    }

    public String getTableName() {
        return "";
    }

    @Override
    public String getDefault() {
        SqlConstraintDefinition constraint = (SqlConstraintDefinition)this.getStubOrPsiChild(SqlCompositeElementTypes.SQL_DEFAULT_CONSTRAINT_DEFINITION);
        SqlExpression expression = constraint == null ? null : (SqlExpression)constraint.getConstraintParameter(SqlConstraintDefinition.EXPRESSION);
        return expression == null ? null : expression.getText();
    }

    protected Icon getBaseIcon() {
        return DatabaseIcons.Col;
    }

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (this.getStub() != null) {
            return this.getIcon();
        }
        return this.getIconSuper(flags);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlType type = super.getSqlType();
        if (type != SqlType.UNKNOWN) {
            SqlType sqlType = type;
            if (sqlType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getSqlType"));
            }
            return sqlType;
        }
        SqlExpression genExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE), SqlExpression.class);
        Object object = genExpression == null ? SqlType.UNKNOWN : genExpression.getSqlType();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getSqlType"));
        }
        return object;
    }

    @Override
    @NotNull
    public DataType getDataType() {
        DataType type = super.getDataType();
        if (type != DataType.UNKNOWN) {
            DataType dataType = type;
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getDataType"));
            }
            return dataType;
        }
        SqlExpression genExpression = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE), SqlExpression.class);
        DataType dataType = genExpression == null ? DataType.UNKNOWN : DataTypeFactory.of(genExpression.getSqlType().getDisplayName());
        if (dataType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlColumnDefinitionImpl", "getDataType"));
        }
        return dataType;
    }

    public boolean processExtraDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault((SqlElement)this, (JBIterable<? extends PsiElement>)SqlImplUtil.childrenIt((PsiElement)this).filter(SqlDefinition.class), true, processor, state, lastParent, place, true);
    }

    private /* synthetic */ boolean lambda$getReferences$0(TextRange textRange, List result2, Object o) {
        DasColumn column;
        DasColumn dasColumn = column = o instanceof DasTable ? (DasColumn)DasUtil.findChild((DasObject)((DasTable)o), DasColumn.class, (ObjectKind)ObjectKind.COLUMN, (String)this.getName()) : null;
        if (column instanceof PsiElement) {
            PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)this, (PsiElement)((PsiElement)column));
            ref.setRangeInElement(textRange);
            result2.add(ref);
        }
        return true;
    }
}

